/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterList.java,v 1.4 2005/02/16 22:24:01 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.util.*;

import org.eclipse.jface.viewers.*;

public class FilterList implements IBasicPropertyConstants
{	
	ArrayList filters = new ArrayList();	
	TableViewer fViewer;

	private List listeners;

	public FilterList(TableViewer viewer)
	{
		fViewer = viewer;
	}
	public void add(FilterTableElement element)
	{
		add(element, -1);
	}
/**
 * Insert the method's description here.
 * Creation date: (08/23/2000 11:25:58 AM)
 * @param elem com.ibm.itp.pd.ui.FilterTableElement
 * @param index int
 */
public void add(FilterTableElement element, int index)
{
	if(index < 0)
		filters.add(element);
	else	
		filters.add(index, element);
/*
	//update ui	
	fViewer.update(new ViewerUpdate(ViewerUpdate.INSERT,
					fViewer.getInput(),
					P_CHILDREN,
					new Object[] {element}));
					*/
}
	/**
 * 
 */
public void addElementChangedListener(FilterListContentProvider newListener) {

	if (newListener == null)
		return;
	if (listeners == null)
		listeners = new ArrayList();
	if (!listeners.contains(newListener))
		listeners.add(newListener);

}
/**
 * Insert the method's description here.
 * Creation date: (08/23/2000 11:34:27 AM)
 * @return java.util.Enumeration
 */
public Object[] elements()
{
	return filters.toArray();	
}
/**
 * 
 */
public void fireElementChanged(FilterTableElement changedElement,String changedProperty) {
	// forward change to content providers.
	if (listeners != null) {
		Iterator e = listeners.iterator();
		while (e.hasNext()) {
			FilterListContentProvider l = (FilterListContentProvider) e.next();
			l.elementChanged(changedElement,changedProperty);
		}
	}
}
	public Object getElementAt(int index) {
		return filters.get(index);
	}
/**
 * Insert the method's description here.
 * Creation date: (11/13/2000 12:53:52 PM)
 * @return java.util.Vector
 */
public ArrayList getFilters()
{
	return (ArrayList)filters.clone();
}
/**
 * Insert the method's description here.
 * Creation date: (09/18/2000 4:02:44 PM)
 * @return int
 */
public int getSize() {
	return filters.size();
}
/**
 * Insert the method's description here.
 * Creation date: (08/22/2000 4:53:57 PM)
 */
public void removeAll()
{
	/*
   Object[] objects = new Object[filters.size()];
   filters.copyInto(objects);
   	*/
   filters.clear();
}

public void removeElements(int idx[])
{
	if (idx == null) return;
	
	Vector removeList = new Vector();
	for (int i=0;i<idx.length;i++)
	{
		if (idx[i]!=-1)
		{
			Object element = filters.get(idx[i]);
			removeList.add(element);
		}
	}
	filters.removeAll(removeList);
}

/**
 * Insert the method's description here.
 * Creation date: (08/22/2000 3:48:34 PM)
 * @param idx int
 */
public Object removeElementAt(int idx)
{
	Object element = filters.get(idx);

	if(element == null)
	  return null;
	  
	filters.remove(element);
	
	return element;
/*
	//update ui	
	fViewer.update(new ViewerUpdate(ViewerUpdate.REMOVE,
					fViewer.getInput(),
					P_CHILDREN,
					new Object[] {element}));
					*/
}
	/**
 * Removes a listener for selection changes.
 */
public void removeElementChangedListener(FilterListContentProvider listener) {

	if (listeners != null)
		listeners.remove(listener);
}
/**
 * Insert the method's description here.
 * Creation date: (08/23/2000 11:34:27 AM)
 * @return java.util.Enumeration
 */
public Object[] uiElements()
{
	return filters.toArray();
}
}
