/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterSetElement.java,v 1.5 2005/02/16 22:24:01 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.util.*;

/**
 * An element with differently typed properties.
 * Changing a property sends out a DomainEvent.
 */
public class FilterSetElement
{
    private String fName;
	private ArrayList fChildren;

		/**
	 * Initialize a new TestElement from the given data.
	 */
	public FilterSetElement(String name)
	{
		fName = name;
	}
		
	public String getName() {
		return fName;
	}
	
	public void setName(String name) {
		fName= name;
	}
	
	public ArrayList getChildren()
	{
		return fChildren;		
	}
	
	public void setChildren(ArrayList children)
	{
		fChildren = children;
	}
}
