/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MonitorContentProvider.java,v 1.4 2005/02/16 22:24:01 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/**
 * Provides content for a tree viewer that shows only containers.
 */
public class MonitorContentProvider implements ITreeContentProvider {
	private Viewer viewer;
/**
 * Creates a new ResourceContentProvider.
 */
public MonitorContentProvider() {
}
/**
 * The visual part that is using this content provider is about
 * to be disposed. Deallocate all allocated SWT resources.
 */
public void dispose() {}
/**
 * @see ITreeContentProvider#getChildren
 */
public Object[] getChildren(Object element)
{
	if (element instanceof IWorkspace)
	{
		return ((IWorkspace) element).getRoot().getProjects();
	}
	else if (element instanceof IContainer)
	{
		List names = new ArrayList();
	    List children = new ArrayList();		
		IContainer container = (IContainer)element;
		if (container.isAccessible())
		{
		    try {

			    IResource[] members = container.members();
			    for (int i = 0; i < members.length; i++)
			    {
				    if (members[i].getType() == IResource.FILE)
				    {
					    IFile file = (IFile) members[i];
					    if(file.getFileExtension() != null && file.getFileExtension().equals(TraceConstants.MONITOR_EXT))
					    {
						    children.add(file);
						    names.add(file.getName().substring(0, file.getName().length()-file.getFileExtension().length()-1));
					    }
				    }
				    else
					    children.add(members[i]);				    
			    }
			} catch (CoreException e) {
				// this should never happen because we call #isAccessible before invoking #members
			}

			ArrayList monitors = PDContentProvider.getMonitors(container);
			for(int idx=0; idx<monitors.size(); idx++)
			{
				Object obj = monitors.get(idx);
				if(obj instanceof TRCMonitor)
				{
					TRCMonitor monitor = (TRCMonitor) obj;
					if(!names.contains(monitor.getName()))
					   children.add(monitor);
				}
			}
			
		    return children.toArray();
			
		}
	}
	return new Object[0];
}
/**
 * @see ITreeContentProvider#getElements
 */
public Object[] getElements(Object element) {
	return getChildren(element);
}
/**
 * @see ITreeContentProvider#getParent
 */
public Object getParent(Object element) {
	if (element instanceof IResource) 
		return ((IResource) element).getParent();
	return null;
}
/**
 * @see ITreeContentProvider#hasChildren
 */
public boolean hasChildren(Object element) {
	return getChildren(element).length > 0;
}
/**
 * @see IContentProvider#inputChanged
 */
public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
	this.viewer = viewer;
}
/**
 * @see IContentProvider#isDeleted
 */
public boolean isDeleted(Object element) {
	return ((element instanceof IResource) && !((IResource) element).exists());
}
}
