/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfilingAgentList.java,v 1.1 2005/04/19 23:24:25 ewchan Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.util.Vector;

import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.trace.ui.internal.launcher.AgentAttribute;

public class ProfilingAgentList {

	private Vector items;

	public ProfilingAgentList() {
		items = new Vector();
	}

	public void initializeFromAgents(Object[] p_items) {
		items.clear();

		for (int i = 0; i < p_items.length; i++) {
			if (p_items[i] instanceof ProcessTreeItem)
				addAgent((ProcessTreeItem)p_items[i]);
		}
	}

	public void addAgent(ProcessTreeItem item) {
		items.addElement(item);
	}
	
	protected ProcessTreeItem agent(int i)
	{
		return (ProcessTreeItem)items.get(i);
	}

	public void removeAgent(ProcessTreeItem item) {
		items.removeElement(item);
	}

	public ProcessTreeItem[] getAgents() {
		ProcessTreeItem[] processTreeItems = new ProcessTreeItem[items.size()];
		items.toArray(processTreeItems);
		
		return processTreeItems;
	}

	public int getAgentCount() {
		return items.size();
	}
	
	public ProcessTreeItem[] getProcessList() {
		Vector processV = new Vector();
		int processCount = 0;
		
		ProcessTreeItem pti;
		for (int i = 0; i < getAgentCount(); i++) {
			pti = agent(i).getParent();
			if (!processInProcessVector(pti.getProcessId(), processV))
			{
				processV.addElement(pti);
				processCount++;				
			}
		}		
		
		ProcessTreeItem[] processTreeItems = new ProcessTreeItem[processCount];
		processV.toArray(processTreeItems);
		
		return processTreeItems;

	}	
	
	private boolean processInProcessVector(String pid, Vector processV)
	{
		for (int i = 0; i < processV.size(); i++)
		{
			if (pid.equals( ((ProcessTreeItem)processV.get(i)).getProcessId()))
				return true;
		}
		
		return false;
	}
	
	public boolean agentInList(ProcessTreeItem pti)
	{
		if (pti.getData() instanceof Agent)
		{
			Agent agent = (Agent)pti.getData();
			return getAgentForAgentAttribute(pti.getProcessId(), agent.getName(), agent.getType()) != null;
		}
		
		return false;
	}
 
	private ProcessTreeItem getAgentForAgentAttribute(String pid, String name, String type)
	{
		for (int i = 0; i < getAgentCount(); i++) {
			Agent agentElem = (Agent)agent(i).getData();
			String elemPid = agent(i).getProcessId();

				if (agentElem.getName().equals(name)
					 && agentElem.getType().equals(type)
					 && elemPid.equals(pid))
					return (ProcessTreeItem)items.get(i);
		}		
		
		return null;
	}


	public ProcessTreeItem getAgentForAgentAttribute(AgentAttribute agAttr)
	{
		return getAgentForAgentAttribute(agAttr.getPID(), agAttr.getName(), agAttr.getType());
	}	
}
