/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfilingTypeElement.java,v 1.5 2005/02/16 22:24:02 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.util;

/**
 * @author znensi
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ProfilingTypeElement {
	
	String fName;
	String fActiveFilterSet;
	private ProfilingList fParent;
	private String fParentName;
	private boolean fEnabled;
	
	public static final String P_NAME= "name";
	
	
	public ProfilingTypeElement(String parentName, String name, boolean enabled)
	{
		fName = name;
		fParentName = parentName;
		fEnabled = enabled;
	}

	/**
	 * @return Returns the fActiveFilterSet.
	 */

	/**
	 * @return Returns the fName.
	 */
	public String getName() {
		return fName;
	}

	/**
	 * @param name The fName to set.
	 */
	public void setName(String name) {
		fName = name;
	}

	/**
	 * @param parent The fParent to set.
	 */
	public void setParent(ProfilingList parent) {
		fParent = parent;
	}
	
	public ProfilingList getParent()
	{
		return fParent;
	}

	/**
	 * @return Returns the fParentName.
	 */
	public String getParentName() {
		return fParentName;
	}

	/**
	 * @param parentName The fParentName to set.
	 */
	public void setParentName(String parentName) {
		fParentName = parentName;
	}
	
	/**
	 * 
	 * @param enabled- whether element is selected in tree
	 */
	public void setEnabled(boolean enabled)
	{
		fEnabled = enabled;
	}
	/**
	 * 
	 * @return whether this profilingType is selected
	 */
	public boolean getEnabled()
	{
		return fEnabled;
	}

}
