/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TString.java,v 1.5 2005/02/16 22:24:02 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.text.*;

import org.eclipse.emf.common.util.*;

/**
 * This class provides static methods for some of the
 * very used IString operations
 */

public class TString
{
	
  private static NumberFormat _decimalFormat = null;
  private static NumberFormat _percentFormat = null;
  private static StringBuffer tmpBuffer = new StringBuffer();

  // change all occurrences of oldPat to newPat
  public  static String change(String in, String oldPat, String newPat)
  {
	 if (oldPat.length() == 0)
		return in;
	 if (oldPat.length() == 1 && newPat.length() == 1)
		return in.replace(oldPat.charAt(0), newPat.charAt(0));

	 int lastIndex = 0;
	 int newIndex = 0;
	 tmpBuffer.setLength(0);
	  
	 for(;;)
	 {
		newIndex = in.indexOf(oldPat, lastIndex);
		if (newIndex != -1)
		{
		   tmpBuffer.append(in.substring(lastIndex, newIndex)).append(newPat);
		   lastIndex = newIndex + oldPat.length();
		}
		else
		{
		   tmpBuffer.append(in.substring(lastIndex));
		   break;
		}
	 }
	 return tmpBuffer.toString();
  }   

	public static String formatAsPercentage(double d) {
		
	  if (_percentFormat == null) {
	  	_percentFormat = NumberFormat.getPercentInstance();
		_percentFormat.setMaximumIntegerDigits(3);
		_percentFormat.setMaximumFractionDigits(2);
		_percentFormat.setMinimumFractionDigits(2);		
	  }
	  return _percentFormat.format(d);
	}

	public static String formatTimeValue(double d)
	{
	  if (_decimalFormat == null) {
	  	_decimalFormat = NumberFormat.getNumberInstance();
		_decimalFormat.setMaximumFractionDigits(6);
		_decimalFormat.setMinimumFractionDigits(6);		
	  }
	  return _decimalFormat.format(d);
	}
	   
  public static long getLong(String str)
  {
	 try {
		return Long.parseLong(str);
	 }
	 catch(Exception m) {
		return 0;
	 }
  }  
   public static String resourcePath(URI uri)
   {
   	  String path = uri.path();
  
   	  if(path.startsWith("/resource"))
   	    return path.substring(9);
   	  
   	  if(path.startsWith("platform:/resource"))
   	    return path.substring(18);

   	  return path;  
   }

   public static String stripNewLineChar(String src)
   {
   	   return src.replaceAll("\n", "").replaceAll("\r", "");
   }
   
    /**
     * 
     */
	public static long getTime(double etime)
	{
		return (long)(etime*1000000);
	}

}
