/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EditWizard.java,v 1.4 2005/02/16 22:24:02 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileOverviewUI;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;

public class EditWizard extends ProfileSetWizard {

	private String id;
	
	public EditWizard(TraceProfileOverviewUI overviewUI)
	{
		super(overviewUI);
	}	
	
	public void initializeSet(IProfilingSet set)
	{
		id = set.getId();

		init(org.eclipse.ui.PlatformUI.getWorkbench(), null);
		setWindowTitle(UIPlugin.getResourceString("STR_EDIT_PROFILINGSET_TITLE"));
		
		super.initializeSet(set);
	}
	
	protected String getSetId()
	{
		return id;
	}
}
