/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id:
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterResourceFileHandler;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterResourceHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;

public class ExportFilterWizardPage extends  ExportImportFilterWizardPage {
    //~ Constructors -------------------------------------------------------------------------------
    /**
     *  Creates an instance of this class
     * @param aWorkbench IWorkbench
     * @param selection IStructuredSelection
     */
    public ExportFilterWizardPage(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("FilterExportPage", aWorkbench, selection); //$NON-NLS-1$
        setTitle(UIPlugin.getResourceString("EXPORT_FILTER_PAGE_TITLE")); //$NON-NLS-1$
        setDescription(UIPlugin.getResourceString("EXPORT_FILTER_PAGE_DESC")); //$NON-NLS-1$
        setImageDescriptor(PDPluginImages.getImageDescriptor(PDPluginImages.IMG_UI_WZ_EXPORT_FILTER));
    }

    //~ Methods ------------------------------------------------------------------------------------

    /** (non-Javadoc)
     * Method declared on IDialogPage.
     */
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, SWT.NULL);

        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_FILL | GridData.HORIZONTAL_ALIGN_FILL));
        composite.setSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));

        createBoldLabel(composite, UIPlugin.getResourceString("STR_SELECT_FILTER_EXPORT_LABEL")); //$NON-NLS-1$
		
        createDoubleList(composite, UIPlugin.getResourceString("EXPORT_AVAILABLE_FILTERS"),UIPlugin.getResourceString("EXPORT_SELECTED_FILTERS")); //$NON-NLS-1$ //$NON-NLS-2$
		
		createSourceGroup(composite);
        createSpacer(composite);

		initializeValues();
		
        setControl(composite);
    }

	protected List populateFilterList() {
		
		FilterResourceHandler resource = FilterResourceHandler.instance();
		Object[] filterQueries = resource.toArray();
		List list = new ArrayList();
		for (int i = 0; i < filterQueries.length; i++)
		{
			list.add(filterQueries[i]);
		}
		
		return list;
	}
    /**
     * The Finish button was pressed.  Try to do the required work now and answer
     * a boolean indicating success.  If <code>false</code> is returned then the
     * wizard will not close.
     *
     * @return boolean
     */
    public boolean finish() {
    	List filtersToExport = getDoubleList().getTargetItems();
    	
    	String exportFile = sourceNameField.getText().trim();
    	if (!exportFile.endsWith(".filtxml"))
    		exportFile = exportFile + ".filtxml";

    	FilterResourceFileHandler exportResourceHandler = FilterResourceFileHandler.instance(URI.createFileURI(exportFile));

    	exportResourceHandler.clear();
    	for (int i = 0; i < filtersToExport.size(); i++)
    	{
    		exportResourceHandler.addFilter(((FilterQueries)filtersToExport.get(i)).copy());
    	}
    	
    	exportResourceHandler.save();
    	exportResourceHandler.unload();    	

    	return true;
    }


	protected boolean validateLists() {
		return true;
	}
}
