/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.IAdvancedTabAttributeSet;
import org.eclipse.hyades.trace.ui.filters.IFilterAttribute;
import org.eclipse.hyades.trace.ui.internal.filters.BasicFeatureFilterAttribute;


public class ImportTraceAdvancedTabAttributeSet implements IAdvancedTabAttributeSet
{
	private static RelationalOperators[] _operators = new RelationalOperators[]
    {
		RelationalOperators.get(RelationalOperators.EQ),
		RelationalOperators.get(RelationalOperators.NEQ),		
		RelationalOperators.get(RelationalOperators.LIKE)
    };
	
	
	private IFilterAttribute[] _attributes = new IFilterAttribute[]
	{
		new BasicFeatureFilterAttribute("ftimptrace_ad1", UIPlugin.getResourceString("STR_ST_FILTER_PACKAGE_NAME"), TracePackage.eINSTANCE.getTRCPackage_Name(), _operators, true),
		new BasicFeatureFilterAttribute("ftimptrace_ad2", UIPlugin.getResourceString("STR_ST_FILTER_CLASS_NAME"), TracePackage.eINSTANCE.getTRCClass_Name(), _operators, true),
		new BasicFeatureFilterAttribute("ftimptrace_ad3", UIPlugin.getResourceString("STR_ST_FILTER_METHOD_NAME"), TracePackage.eINSTANCE.getTRCMethod_Name(), _operators, true),
		new BasicFeatureFilterAttribute("ftimptrace_ad4", UIPlugin.getResourceString("STR_ST_FILTER_THREAD_NAME"), TracePackage.eINSTANCE.getTRCThread_Name(), _operators, true)
	};
	
	
	public IFilterAttribute[] getAttributes() {
		return _attributes;
	}
}

	
