/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NewMonitorWizard.java,v 1.5 2005/02/16 22:24:02 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.*;

import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.jface.wizard.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.core.resources.*;
import org.eclipse.ui.*;

public class NewMonitorWizard extends Wizard implements INewWizard
{

  protected PDProjectExplorer fViewer;
  protected IStructuredSelection fSelection;
  protected IResource fResource;
  protected NewMonitorWizardPage fPage;

  public NewMonitorWizard()
  {
	setNeedsProgressMonitor(true);
  }  
  public void addPages()
  {
  	setWindowTitle(UIPlugin.getResourceString("MONITOR_WIZARD_TITLE"));	
	fPage = new NewMonitorWizardPage("com.ibm.etools.pd.core.wizard.NewMonitorPage",fResource);
	addPage(fPage);
  }  
/**
 * Insert the method's description here.
 * Creation date: (8/7/2001 4:25:43 PM)
 * @return com.ibm.etools.pd.core.PDProjectExplorer
 */
public PDProjectExplorer getViewer() {
	return fViewer;
}
  public void init(IWorkbench workbench, IStructuredSelection selection)
  {
	fSelection = selection;
	if (selection instanceof IStructuredSelection)
	{
	  Iterator enum = ((IStructuredSelection) selection).iterator();
	  if (enum.hasNext())
	  {
		Object cg = enum.next();
		if (cg instanceof IResource)
		{		
		  fResource = (IResource) cg;
		}
	  }
	}

	setDefaultPageImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_NEWMON));	
  }  
  public boolean performFinish()
  {
	if (fPage.finish())
	{	
	  fViewer.getViewer().refresh();			
	  fViewer.selectObject(fPage.getMonitor());		  
	 
	  return true;
	}
	return false;
  }  
  public void setViewer(PDProjectExplorer viewer)
  {
	fViewer = viewer;

	((PDProjectViewer)viewer.getViewer()).createSelectedNodeChildren();	
  }  
}
