/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenMonitorWizard.java,v 1.5 2005/02/16 22:24:02 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.*;

import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;

public class OpenMonitorWizard extends NewMonitorWizard
{
	TRCMonitor fMonitor;

  public OpenMonitorWizard()
  {
	  super();
  }  
  public void addPages()
  {
  	setWindowTitle(UIPlugin.getResourceString("STR_PROPERTIES"));	
	fPage = new OpenMonitorWizardPage("openMonitorPage", fResource);
	addPage(fPage);
  }    
/**
 * Insert the method's description here.
 * Creation date: (10/05/2000 3:20:17 PM)
 * @return com.ibm.etools.perftrace.TRCMonitor
 */
public TRCMonitor getMonitor() {
	return fMonitor;
}
  public void init(IWorkbench workbench, IStructuredSelection selection)
  {
	if (selection instanceof IStructuredSelection)
	{
	  Iterator enum = ((IStructuredSelection) selection).iterator();
	  if (enum.hasNext())
	  {
		Object obj = enum.next();
		if (obj instanceof TRCMonitor)
		{		
		  fMonitor = (TRCMonitor) obj;
		}
	  }
	}
	
	setDefaultPageImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_MON_PROP));
  }  
  public boolean performFinish()
  {
	return fPage.finish();
  }  
  public void setViewer(PDProjectExplorer viewer)
  {
	fViewer = viewer;

	fResource = HyadesUtil.getSelectionFolder(fViewer);
  }  
}
