/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenProfAgentPage.java,v 1.8 2005/02/16 22:24:02 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.*;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/*
* CONTEXT_ID opap0000 for open profile agent page
*/

public class OpenProfAgentPage  extends WizardPage 
{
	protected PDProjectExplorer fViewer;
	protected TraceProfileFiltersUI _profileUI;
		
  public OpenProfAgentPage(String name, PDProjectExplorer viewer)     

  {
	super(name);
	//setTitle("Trace Profile Data"); 
	setTitle(UIPlugin.getResourceString("PROF_AGENT_TITLE"));
	setDescription(UIPlugin.getResourceString("PROF_AGENT_DESC")); 
	fViewer = viewer;
	  
  }    /**
 * Insert the method's description here.
 * Creation date: (08/22/2000 4:48:53 PM)
 * @param show boolean
 */      
  public void createControl(Composite parent)
  {
	Label label;

	Composite content = new Composite(parent, SWT.NONE);
	GridLayout layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=5;       
	content.setLayout(layout);
	GridData gd = GridUtil.createFill();
	gd.widthHint = 500;
	gd.heightHint = 400;
	content.setLayoutData(gd);

	_profileUI = new TraceProfileFiltersUI();
	_profileUI.createControl(content);

	TRCAgentProxy agent = ((OpenProfAgentWizard)getWizard()).getAgent();

	if(agent == null || !agent.isActive())
	{
		_profileUI.setAgentTerminated(true);
		_profileUI.enable(false);
	}
	
	setControl(content);

	populateData();

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
	UIPlugin.getPluginId()+".opap0000");
  }  
  public boolean finish()
  {     
	TRCAgentProxy agent = ((OpenProfAgentWizard)getWizard()).getAgent();

	if(agent == null || !agent.isActive())
	  return true;

	try {
		Object[] configs = agent.getConfigurations().toArray();

		if(configs.length > 0)
		{
			setConfiguration((TRCConfiguration)configs[0]);                 
		}
		else
		{
			HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();         
			TRCConfiguration config = factory.createTRCConfiguration();
			config.setActive(true);
			config.setName(UIPlugin.getResourceString("STR_DEFAULT_SET_NAME"));
			config.setAgentProxy(agent);
			agent.getConfigurations().add(config);

			setConfiguration(config);           
		}
		
		/* Send the configuration to the agent if the trace is active and monitored.
		 * The configuration is only send if 'shouldSend' is set. */
		if(agent.isActive() && agent.isMonitored())
		{
			TRCProcessProxy process = agent.getProcessProxy();
			TRCNode node = process.getNode();
			sendConfigurationToAgent(agent, node.getName(), process.getPid());			
			
		}
		
	}
	catch(ConcurrentModificationException exc)
	{
		exc.printStackTrace();
	}
		
	return true;    

  } 
  
  /**
   * Insert the method's description here.
   * Creation date: (11/10/2000 12:50:32 PM)
   * @param agent com.ibm.etools.perftrace.TRCAgent
   */
  private void sendConfigurationToAgent(TRCAgentProxy agent, String host, int processId)
  {
  	Node node = PDCoreUtil.profileConnect(host, String.valueOf(agent.getProcessProxy().getNode().getPort()));
  	if(node == null)
  		return;

  	
  	Process p = node.getProcess(String.valueOf(processId));

  	if(p != null)
  	{
  		try {
  			Agent a = p.getAgent(agent.getName());
  			PDCoreUtil.setAgentConfiguration(agent, a);
  			if(a != null && a.isActive()) {
  			  a.publishConfiguration();

  			  /* Apply the filters */
  			  CustomCommand command = new CustomCommand();
  			  command.setData("APPLYFILTERS");
  			  a.invokeCustomCommand(command);	
  			  
  			}			
  		}
  		catch(InactiveAgentException aex)
  		{
  		}
  	}
  }
  
/**
 * Insert the method's description here.
 * Creation date: (10/05/2000 3:17:53 PM)
 */
protected void populateData()
{
	TRCAgentProxy agent = ((OpenProfAgentWizard)getWizard()).getAgent();

	if(agent == null)
	  return;

	EList filters = null;
	
	EList configs = agent.getConfigurations();
	Iterator i = configs.iterator();
	if (i.hasNext())
	{
		TRCConfiguration config = (TRCConfiguration)i.next();
		filters = config.getFilters();

		updateConfigData(config.getName(), filters);                         
		return;
	}

	updateConfigData(UIPlugin.getResourceString("STR_DEFAULT_SET_NAME"), filters);                     
}
/**
 * Insert the method's description here.
 * Creation date: (08/22/2000 5:45:29 PM)
 * @param config com.ibm.etools.perftrace.TRCConfiguration
 */
protected void setConfiguration(TRCConfiguration config)
{
	try {
	
	Object[] filters = config.getFilters().toArray();

	//delete the filters
	for(int idx=0; idx<filters.length; idx++)   
	{
		((TRCFilter)filters[idx]).setConfiguration(null);
	}

	//add the UI options    
	HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory(); 
	//add UI filters
	String selected = _profileUI.getActiveFilterSet();
	ArrayList filterSet = _profileUI.getFilterSet();
	for(int i=0; i<filterSet.size(); i++)
	{
		FilterSetElement set = (FilterSetElement) filterSet.get(i);
		if(set.getName().equals(selected))
		{
			config.setActive(true);
			config.setName(set.getName());
			UIPlugin.getDefault().getPluginPreferences().setValue(TraceConstants.ACTIVE_FILTER_NAME, set.getName());
						
			ArrayList filterList = set.getChildren();
			for(int idx=0; idx<filterList.size(); idx++)
			{
				FilterTableElement elem = (FilterTableElement)filterList.get(idx);
				
				TRCFilter filter = factory.createTRCFilter();
				filter.setMode(elem.getVisibility().equals(UIPlugin.getResourceString("STR_INCLUDE"))?"INCLUDE":"EXCLUDE");
				filter.setPattern(elem.getText());
		        filter.setOperation(elem.getMethod());		
				filter.setType("CLASS");			
				filter.setActive(new Boolean(true));
		
				filter.setConfiguration(config);       
			}
			
			break;
		}
	}
		
}
catch(ConcurrentModificationException exc)
{
	exc.printStackTrace();
}
		
}
protected void updateConfigData(String name, EList filters)
{	
	ArrayList list = new ArrayList();
	if (filters != null)
	{
		Iterator i = filters.iterator();
		while (i.hasNext())
		{
			TRCFilter filter = (TRCFilter)i.next(); 
			String method = filter.getOperation();
			if(method!=null)  			 
				list.add(new FilterTableElement(filter.getPattern(), method, filter.getMode().equals("INCLUDE")?UIPlugin.getResourceString("STR_INCLUDE"):UIPlugin.getResourceString("STR_EXCLUDE")));
			else	
				list.add(new FilterTableElement(filter.getPattern(), "*", filter.getMode().equals("INCLUDE")?UIPlugin.getResourceString("STR_INCLUDE"):UIPlugin.getResourceString("STR_EXCLUDE")));			
		}
	}
	
	FilterSetElement elem = new FilterSetElement(name);
	elem.setChildren(list);
	_profileUI.addFilterSet(elem);
	_profileUI.setActiveFilterSet(elem);
}

	public void setVisible(boolean visible) {
		super.setVisible(visible);

		if (visible) {
			if (!((OpenProfAgentWizard)getWizard()).isProfilingAgent()) {
				this.getControl().setEnabled(false);
				this.getControl().setVisible(false);
				this.setDescription(UIPlugin.getResourceString("STR_FILTER_IGNORED"));
			} else {
				this.getControl().setEnabled(true);
				this.getControl().setVisible(true);
				this.setDescription(UIPlugin.getResourceString("PROF_AGENT_DESC"));
			}
		}
	}


}
