/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenProfAgentWizard.java,v 1.11 2005/02/16 22:24:02 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.Iterator;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.*;

public class OpenProfAgentWizard extends Wizard implements INewWizard
{
  protected TRCAgentProxy fAgent;
  protected PDProjectExplorer fViewer;
  protected OpenProfAgentPage fFilterPage;
  protected OpenProfAgentFolderPage fFolderPage;
  protected OpenProfAgentOptionsPage fPropertyPage;
  
  private boolean debug=UIPlugin.getDefault().getPreferenceStore().getBoolean(TraceConstants.DEBUG_OPTION);
   
public OpenProfAgentWizard()
  {
	  super();
  }  
  public void addPages()
  {
  	setWindowTitle(UIPlugin.getResourceString("STR_PROPERTIES"));	
	fFolderPage = new OpenProfAgentFolderPage("folderPage", fViewer);
	fFilterPage = new OpenProfAgentPage("agentPage", fViewer);
	if (debug)
		fPropertyPage = new OpenProfAgentOptionsPage("propertiesPage");
	
	addPage(fFolderPage);
	addPage(fFilterPage);
	if (debug)
		addPage(fPropertyPage);
  }    
/**
 * Insert the method's description here.
 * Creation date: (10/05/2000 4:33:24 PM)
 * @return com.ibm.etools.perftrace.TRCAgent
 */
public TRCAgentProxy getAgent() {
	return fAgent;
}

  public void init(IWorkbench workbench, IStructuredSelection selection)
  {
	if (selection instanceof IStructuredSelection)
	{
	  Iterator enum = ((IStructuredSelection) selection).iterator();
	  if (enum.hasNext())
	  {
		Object obj = enum.next();
		if (obj instanceof TRCAgentProxy)
		  fAgent = (TRCAgentProxy) obj;
	  }
	}
	
	setDefaultPageImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_AGENT_PROP));
  }  
  public boolean performFinish()
  {
  	
  	if (!fFolderPage.getFile().equals("") && !PDCoreUtil.isPathExists(fFolderPage.getFile()))
	{
		if (!PDCoreUtil.createDirectoryMessage(fFolderPage.getFile(),getShell()))
				return false;
	}
  	
	fFilterPage.finish();
	fFolderPage.finish();
	if (debug)
		fPropertyPage.finish();
	
  	return true;
  }  
  public void setViewer(PDProjectExplorer viewer)
  {
	fViewer = viewer;
  }
  
  public boolean isProfilingAgent()
  {
  		if (fAgent!=null)
  		{
  			return (fAgent.getType().equals(TraceConstants.PROFILE_AGENT_TYPE)
				&& !fAgent.getName().equals(TraceConstants.J2EE_AGENT_NAME));
  		}
		return true;
  }  

}
