/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileSetWizardDialog.java,v 1.3 2005/02/16 22:24:02 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class ProfileSetWizardDialog extends WizardDialog {

	private ProfilingSetsManagerCopy _copy;
	
	/**
	 * @param parentShell
	 * @param newWizard
	 */
	public ProfileSetWizardDialog(Shell parentShell, IWizard newWizard) {
		super(parentShell, newWizard);
		
		_copy = ((ProfileSetWizard)getWizard()).getProfilingSetsManagerCopy();
	}
	
	
	protected Control createContents(Composite parent) {
		Control control = super.createContents(parent);
		ProfileSetWizardPage1 page1 = (ProfileSetWizardPage1)getWizard().getPages()[0];
		ProfileSetWizardPage2 page2 = (ProfileSetWizardPage2)getWizard().getPages()[1];
		ProfileSetWizardPage3 page3 = (ProfileSetWizardPage3)getWizard().getPages()[2];		
		page1.initializeFrom(_copy);
		page2.initializeFrom(_copy);
		page3.initializeFrom(_copy);		
		return control;
	}
	
	protected void backPressed() {
		IProfileSetWizardPage page = (IProfileSetWizardPage)getCurrentPage();
		

		if (page.performApply(_copy)) {
			IProfileSetWizardPage previous = (IProfileSetWizardPage)page.getPreviousPage();
			previous.initializeFrom(_copy);
			super.backPressed();
		}
	}	
	
	protected void nextPressed() {
		IProfileSetWizardPage page = (IProfileSetWizardPage)getCurrentPage();
		
		if (page.performApply(_copy)) {
			IProfileSetWizardPage next = (IProfileSetWizardPage)page.getNextPage();
			next.initializeFrom(_copy);
			super.nextPressed();
		}		

	}
	
	protected void finishPressed() {
		boolean ok = false;
		IProfileSetWizardPage page = (IProfileSetWizardPage)getCurrentPage();

		ok = page.performApply(_copy);

		if (ok) {
			super.finishPressed();
		}
	}	

}
