/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IProfilingSet.java,v 1.4 2005/02/16 22:24:02 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.launcher;

import java.util.*;
import java.util.Map;

/**
 * 
 * Profiling Set Interface
 * Related to the profilingSets schema.
 **/
public interface IProfilingSet{
	
	/**
	 * @return Returns the id of the profiling set
	 */
	public String getId();
	
	/**
	 * @param id The id for the profiling set
	 */
	public void setId(String id);
	
	/**
	 * @return Returns the name of the profiling set
	 */
	public String getName();
	
	/**
	 * @param name The name to set for the current profiling set
	 */
	public void setName(String name);
	
	/**
	 * @return Returns the profiling set attributes.
	 */
	public Map getAttributes();
	
	/**
	 * Set profiling set attributes
	 * @param attributes The attributes to set. The map contains ProfilingOptions elements
	 */
	public void setAttributes(Map attributes);
	
	/**
	 * @return Returns a list of strings containing profiling types Id
	 */
	public List getProfilingTypes();
	
	/**
	 * Set profiling types for the current profiling group
	 * The list contains profiling type id's
	 * @param profilingTypes The profilingTypes to set.
	 */
	public void setProfilingTypes(List profilingTypes);
	
	/**
	 * @return Returns the description.
	 */
	public String getDescription();
	
	/**
	 * @param description 
	 */
	public void setDescription(String description);
	
}
