/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HyadesWorkbenchAdapter.java,v 1.4 2005/02/16 22:24:04 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.adapter;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.util.INamedElement;

/**
 * Workbench adapter for Hyades objects.  If it is not one of the Hyades objects
 * then the returned values are obtained from the default 
 * <code>IWorkbenchAdapter</code>.
 * 
 * @author marcelop
 * @since 0.0.1 
 */
public class HyadesWorkbenchAdapter 
implements IHyadesWorkbenchAdapter
{
	/**
	 * @see org.eclipse.ui.model.IWorkbenchAdapter#getLabel(java.lang.Object)
	 */
	public String getLabel(Object object)
	{			
		if(object instanceof INamedElement)
			return ((INamedElement)object).getName();

		if(object instanceof IAdaptable)
		{
			INamedElement namedElement = (INamedElement)((IAdaptable)object).getAdapter(INamedElement.class);
			if(namedElement != null)
				return namedElement.getName();
		}

		IWorkbenchAdapter workbenchAdapter = getWorkbenchAdapter(object);
		if(workbenchAdapter != null)
			return workbenchAdapter.getLabel(object);
			
		return "";
	}

	/**
	 * @see org.eclipse.hyades.ui.adapter.IHyadesWorkbenchAdapter#getDescription(java.lang.Object)
	 */
	public String getDescription(Object object)
	{
		if(object instanceof INamedElement)
			return ((INamedElement)object).getDescription();

		if(object instanceof IAdaptable)
		{
			INamedElement namedElement = (INamedElement)((IAdaptable)object).getAdapter(INamedElement.class);
			if(namedElement != null)
				return namedElement.getName();
		}

		if(object instanceof IResource)
			return ((IResource)object).getFullPath().toString();

		return "";
	}

	/**
	 * @see org.eclipse.ui.model.IWorkbenchAdapter#getImageDescriptor(java.lang.Object)
	 */
	public ImageDescriptor getImageDescriptor(Object object)
	{
		if(object instanceof LogicalFolder)
			return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_OBJ_FOLDER);

		IWorkbenchAdapter workbenchAdapter = getWorkbenchAdapter(object);
		if(workbenchAdapter != null)
			return workbenchAdapter.getImageDescriptor(object);
				
		return null;
	}

	/**
	 * @see org.eclipse.ui.model.IWorkbenchAdapter#getParent(java.lang.Object)
	 */
	public Object getParent(Object object)
	{
		if(object instanceof LogicalFolder)
			return ((LogicalFolder)object).getParent();

		IWorkbenchAdapter workbenchAdapter = getWorkbenchAdapter(object);
		if(workbenchAdapter != null)
			return workbenchAdapter.getParent(object);

		return null;
	}

	/**
	 * @see org.eclipse.hyades.ui.adapter.IHyadesWorkbenchAdapter#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object element)
	{
		if(element instanceof LogicalFolder)
			return ((LogicalFolder)element).hasChildren();
			
		return (getChildren(element).length > 0);
	}

	/**
	 * @see org.eclipse.ui.model.IWorkbenchAdapter#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object object)
	{
		if(object instanceof LogicalFolder)
			return ((LogicalFolder)object).getChildren().toArray();
			
		IWorkbenchAdapter workbenchAdapter = getWorkbenchAdapter(object);
		if(workbenchAdapter != null)
			return workbenchAdapter.getChildren(object);
		
		return new Object[0];
	}
	
	/**
	 * Returns the workbench adapter for a given object.
	 * @param object
	 * @return IWorkbenchAdapter
	 */
	protected IWorkbenchAdapter getWorkbenchAdapter(Object object)
	{
		IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(object, IWorkbenchAdapter.class);
		if(workbenchAdapter == this)
			return null;
			
		return workbenchAdapter;
	}
}
