/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISynchronizedEditorAdapter.java,v 1.4 2005/02/16 22:24:04 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.adapter;

import java.util.List;

/**
 * Instances of this interface are used to customized the operations that 
 * the {@link org.eclipse.hyades.ui.internal.editor.EditorSynchronizer} 
 * performs to synchronize the editor with the OS file system or with the
 * Eclipse's workspace.
 * 
 * @author marcelop
 * @since 0.2.0
 */
public interface ISynchronizedEditorAdapter
{
	/**
	 * Triggers a reload in the editor.
	 * @return <code>true</code> if the editor was reloaded
	 * or <code>false</code> otherwise. 
	 */
	public boolean reload();
	
	/**
	 * Handles modifications in one or more monitored files.  The
	 * lists contains the modified IFiles.
	 * @param changedFiles
	 * @param removedFiles
	 */
	public void handle(List changedFiles, List removedFiles);
	
	/**
	 * This method is invoked when the editor file has been deleted.
	 * @return <code>true</code> if the editor synchronizer should not
	 * perform the default treatment.
	 */
	public boolean editorFileDeleted();

	/**
	 * This method is invoked when the editor file has been changed.
	 * @return <code>true</code> if the editor synchronizer should not
	 * perform the default treatment.
	 */
	public boolean editorFileChanged();

	/**
	 * This method is invoked when the editor file write access has 
	 * been changed.
	 * @param isReadOnly
	 * @return <code>true</code> if the editor synchronizer should not
	 * perform the default treatment.
	 */
	public boolean editorFileWriteAccessChanged(boolean isReadOnly);
	
	/**
	 * This method is invoked when the editor content should be saved.
	 * @param wasDeleted indicates whether the editor file has been deleted.
	 * @return <code>true</code> if the editor synchronizer should not
	 * perform the default treatment.
	 */
	public boolean doSaveEditorFile(boolean wasDeleted);
}
