/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SynchronizedEditorAdapter.java,v 1.4 2005/02/16 22:24:04 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.adapter;

import java.util.List;

/**
 * Implementation of the <code>ISynchronizedEditorAdapter</code> interface.
 * 
 * @author marcelop
 * @since 0.2.0
 */
public class SynchronizedEditorAdapter 
implements ISynchronizedEditorAdapter
{
	/**
	 * @see org.eclipse.hyades.ui.internal.editor.ISynchronizedEditorAdapter#reload()
	 */
	public boolean reload()
	{
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.adapter.ISynchronizedEditorAdapter#doSaveEditorFile(boolean)
	 */
	public boolean doSaveEditorFile(boolean wasDeleted)
	{
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.editor.ISynchronizedEditorAdapter#editorFileDeleted()
	 */
	public boolean editorFileDeleted()
	{
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.editor.ISynchronizedEditorAdapter#editorFileChanged()
	 */
	public boolean editorFileChanged()
	{
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.editor.ISynchronizedEditorAdapter#editorFileWriteAccessChanged(boolean)
	 */
	public boolean editorFileWriteAccessChanged(boolean isReadOnly)
	{
		return false;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.editor.ISynchronizedEditorAdapter#handle(java.util.List, java.util.List)
	 */
	public void handle(List changedFiles, List removedFiles)
	{

	}
}
