/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CopyAction.java,v 1.3 2005/02/16 22:24:04 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.editor.action;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.texteditor.IWorkbenchActionDefinitionIds;

public class CopyAction extends EditAction
{
	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.IAction#getActionDefinitionId()
	 */
	public String getActionDefinitionId()
	{
		return IWorkbenchActionDefinitionIds.COPY;
	}

	public void run()
	{
		Control control = getFocusControl();
		if (control instanceof Text)
		{
			((Text)control).copy();
		}
		else if (control instanceof StyledText)
		{
			((StyledText)control).copy();
		}
		else if (control instanceof Combo)
		{
			((Combo)control).copy();
		}
	}
}
