/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id:
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.ui.internal.extension;

import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;

/**
 * A navigator layout is comprised of a content provider and label provider for
 * a particular navigator, and is used to group or organize the navigator content
 * in different ways (e.g. flat layout / hierarchical layout). It is recommended
 * that navigators allow the user to change the layout by adding one action for each
 * layout in the view drop-down menu.
 * 
 * @author Curtis d'Entremont
 * @since 3.3
 */
public interface INavigatorLayout {

	/**
	 * Returns the content provider that gives the contents to show
	 * for this layout. Different layouts may supply different content.
	 * For example, a flat layout might prune certain grouper nodes in a
	 * tree that a hierarchical display might show.
	 * 
	 * @return the layout's content provider.
	 */
	public IContentProvider getContentProvider();
	
	/**
	 * Returns the label provider that assigns the text to be displayed
	 * for each item in the navigator. Different layouts may provide different
	 * labels depending on how much context information is available. For example,
	 * a flat layout might display an extra bit of information about where the
	 * element comes from, while the hierarchical layout might use parent nodes to
	 * group the content.
	 * 
	 * @return the layout's label provider.
	 */
	public ILabelProvider getLabelProvider();
}
