/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.util;

import java.io.File;
import java.util.Hashtable;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;

/**
 * @author apnan
 *
 */
public class PreferencesUtil {
	
	public static final String SYMPTOM_DB_PATH_KEY = "symptom_db_path";

	public static IPreferenceStore doGetPreferenceStore() {
		IPreferenceStore store = HyadesUIPlugin.getInstance().getPreferenceStore();
		try{
			IPath path = Platform.getPluginStateLocation(ResourcesPlugin.getPlugin());
			File file = path.removeLastSegments(1).addTrailingSeparator().append("org.eclipse.core.runtime").addTrailingSeparator().append(".settings").addTrailingSeparator().append("org.eclipse.hyades.sdb.prefs").toFile();
			if (file.exists() == false) {
				// Eclipse 2.0
				// eclipse_install\runtime-workspace\.metadata\.plugins\org.eclipse.hyades.sdb\pref_store.ini
				file = path.removeLastSegments(1).addTrailingSeparator().append("org.eclipse.hyades.sdb").addTrailingSeparator().append("pref_store.ini").toFile();
			}

			if (file.exists()){
				PreferenceStore ps = new PreferenceStore(file.getAbsolutePath());
				ps.load();
				String[] prefNames = ps.preferenceNames();
				for (int i=0; i<prefNames.length; i++){
					if (!store.contains(prefNames[i]))
						store.putValue(prefNames[i], ps.getString(prefNames[i]));
					else{
						String psValue = ps.getString(prefNames[i]);
						String storeValue = store.getString(prefNames[i]);
						String updated = storeValue + updatePreferenceStore(storeValue, psValue);
						store.putValue(prefNames[i], updated);
					}
				}
				HyadesUIPlugin.getInstance().savePluginPreferences();
				file.delete();
			}
			
			path = Platform.getPluginStateLocation(ResourcesPlugin.getPlugin());
			file = path.removeLastSegments(1).addTrailingSeparator().append("org.eclipse.core.runtime").addTrailingSeparator().append(".settings").addTrailingSeparator().append("com.ibm.etools.symptom.editor.prefs").toFile();
			if (file.exists()){
				PreferenceStore ps = new PreferenceStore(file.getAbsolutePath());
				ps.load();
				String[] prefNames = ps.preferenceNames();
				for (int i=0; i<prefNames.length; i++){
					if (!store.contains(prefNames[i]))
						store.putValue(prefNames[i], ps.getString(prefNames[i]));
					else{
						String psValue = ps.getString(prefNames[i]);
						String storeValue = store.getString(prefNames[i]);
						String updated = storeValue + updatePreferenceStore(storeValue, psValue);
						store.putValue(prefNames[i], updated);
					}
				}
				HyadesUIPlugin.getInstance().savePluginPreferences();
				file.delete();
			}
		}catch(Exception e){
			System.out.println(e.toString());
		}
		return store;
	}
	
	private static String updatePreferenceStore(String str1, String str2){
		if (str1 == null || str1.trim().length() == 0)
			return "\n"+str2;
		
		if (str1.equalsIgnoreCase(str2))
			return "";
		
		String[] urls1 = str1.split("\n");
		Hashtable table = new Hashtable();
		for (int i=0; i<urls1.length; i++){
			String[] strs = urls1[i].split("\t");
			strs[0] = strs[0].trim();
			if (strs[0].length() != 0)
				table.put(strs[0], strs[1]);
		}
		
		String[] urls2 = str2.split("\n");
		String rc = "";
		for (int i=0; i<urls2.length; i++){
			String[] strs = urls2[i].split("\t");
			strs[0] = strs[0].trim();
			if (strs[0].length() != 0 && !table.containsKey(strs[0])){
				rc = rc + "\n" + urls2[i];
			}
		}
		return rc;
	}

	public static void savePreferences(){
		HyadesUIPlugin.getInstance().savePluginPreferences();
	}
}
