/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: WizardElementWorkbenchAdapter.java,v 1.4 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.wizard.selection;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * @author marcelop
 * @since 0.2.0
 */
public class WizardElementWorkbenchAdapter
implements IWorkbenchAdapter, IAdaptable
{
	private static WizardElementWorkbenchAdapter instance; 
	
	public static WizardElementWorkbenchAdapter getInstance()
	{
		if(instance == null)
			instance = new WizardElementWorkbenchAdapter();
		return instance;
	}
	
	private IWizardElement[] wizardElements;
	
	/**
	 * Constructor for WizardElementWorkbenchAdapter
	 */
	private WizardElementWorkbenchAdapter()
	{
	}

	/**
	 * Constructor for WizardElementWorkbenchAdapter
	 */
	WizardElementWorkbenchAdapter(IWizardElement[] wizardElements)
	{
		this.wizardElements = wizardElements;
	}
	
	/**
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter)
	{
		if(IWorkbenchAdapter.class.isAssignableFrom(adapter))
			return this;
		return null;
	}

	/**
	 * @see org.eclipse.ui.model.IWorkbenchAdapter#getImageDescriptor(java.lang.Object)
	 */
	public ImageDescriptor getImageDescriptor(Object object)
	{
		if(object instanceof IWizardElement)
			return ((IWizardElement)object).getImageDescriptor();
		return null;
	}

	/**
	 * @see org.eclipse.ui.model.IWorkbenchAdapter#getLabel(java.lang.Object)
	 */
	public String getLabel(Object object)
	{
		if(object instanceof IWizardElement)
			return ((IWizardElement)object).getLabel();
		return null;
	}

	/**
	 * @see org.eclipse.ui.model.IWorkbenchAdapter#getParent(java.lang.Object)
	 */
	public Object getParent(Object o)
	{
		return null;
	}

	/**
	 * @see org.eclipse.ui.model.IWorkbenchAdapter#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object o)
	{
		if(o == this)
		{
			Object[] ret = wizardElements;
			wizardElements = null;
			return ret;
		}
			
		return new Object[0];
	}
}