/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available a
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IReportGenerator.java,v 1.4 2005/02/16 22:24:05 qiyanli Exp $
 *
 * # %Z% %I% %W% %G% %U% [%H% %T%]
 * 
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.report;

import java.io.InputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelection;

/**
 * Pluggable Report Generator Interface
 * 
 * All report generator specified in the Preferences/Component Test/Local Report Definitions
 * must implement this interface.
 *  
 */
public interface IReportGenerator
{
	/**
	 * If the report is registered into the Component Test tool by the preference page
	 * it will be difficult for the report generator to figure it out where it is 
	 * located in the file system.  So, in this case, this method will be invoked
	 * 
	 * @param String The classpath entered by the user in the preference page.
	 */
	public void setUsedClasspath(String fullPath);
	
	/**
	 * Before the generate method invocation, the Component Test will execute this
	 * method in order to retrieve the extension of the resource that will be created
	 * for the report.
	 * 
	 * @param ISelection The selection
	 * @return String The resource extension
	 */
	public String getReportFileExtension(ISelection selection);

	/**
	 * Check if the report generator is available to the given selection.
	 * 
	 * @param selection The selection.
	 * @return true if the report generator is applicable to the given selection.
	 */
	public boolean isAvailable(ISelection selection);

	/**
	 * This method will be invoked to generate the report for the given selection.
	 * 
	 * <p>The <code>reportFile</code> argument is the Eclipse resource that 
	 * <b>will</b> be created by Component Test using the InputStream returned by the method.  
	 * The implementors of this method should NOT create any resource with this file name.
	 * 
	 * @param IFile The report file that <b>will</b> be created by the Component Test Plugin
	 * @param ISelection The selection
	 * @return InputStream The content of the report
	 * @exception Exception Any exception thrown by this method will be treated.
	 */
	public InputStream generate(IFile reportFile, ISelection selection) throws Exception;
	
}
