/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IFileManagerFactory.java,v 1.2 2005/05/18 16:27:10 jptoomey Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.execution.local.file;

import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.internal.execution.local.control.Connection;

/**
 * Interface to the file manager factory
 * 
 * @author Scott E. Schneider
 */
public interface IFileManagerFactory {
	/**
	 * Creates a new file manager for the client to use in normal mode without
	 * performance timing integration
	 * 
	 * @param connection
	 *            the connection to the agent controller
	 * @return the configured file manager
	 * @provisional
	 */
	public IFileManagerExtended create(Connection connection);

	/**
	 * Create a new timed file manager for the client to use in timed mode
	 * 
	 * @param connection
	 *            the connection to the agent controller to use
	 * @param iterations
	 *            the number of times each method invocation will be called
	 * @return the configured file manager
	 * @provisional
	 */
	public IFileManagerExtended createTimed(Connection connection, int iterations);
}
