package org.eclipse.hyades.execution.security;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IClientHandler.java,v 1.4 2005/02/16 22:20:15 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

public interface IClientHandler {
	
	public byte[] getRemoteAddress();

	/**
	 *  Read bytes from client on secure socket
	 */	
	public int read(byte[] b, int off, int len);
	
	/**
	 *  Write bytes to client on secure socket
	 */
	public int write(byte[] b, int off, int len);
	
	/**
	 *  Close the connection to the client
	 */
	public void closeConnection();
}