/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IFileServerParameters.java,v 1.6 2005/05/03 14:42:25 sschneid Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.file;

/**
 * @author Giridhar.S This is the interface to be implemented by classes which
 *         want to pass parameters to the file server.
 */
public interface IFileServerParameters {

	/**
	 * Method to load the file server with the FileConnectionHandler which
	 * creates client handlers for each client request.
	 * 
	 * @return new ConnectionHandler.
	 */
	public Object getConnectionHandler();

	/**
	 * Method to set the file server port number.
	 * 
	 * @param port
	 */
	public void setPort(int port);

	/**
	 * @return file server port number configured in Agent Controller.
	 */
	public int getPort();
}