/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AuthenticationSuccessfulCommand.java,v 1.4 2005/02/16 22:20:15 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;


/**
 * @author rduggan
 *
 */
public class AuthenticationSuccessfulCommand extends CommandElement implements Constants {

	protected RAString _key=new RAString("");
	
	
	public AuthenticationSuccessfulCommand() {
		super();
		_tag=RA_AUTHENTICATION_SUCCESSFUL;
	}
	
	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#getSize()
	 */
	public int getSize() {
		int size=sizeofLong;
		size+=_key.getSize();
		return size;
	}

	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#readFromBuffer(byte[], int)
	 */
	public int readFromBuffer(byte[] buffer, int offset) {
		int current=offset;
		current=Message.readRAStringFromBuffer(buffer, current, _key);
		return current;
	}

	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#writeToBuffer(byte[], int)
	 */
	public int writeToBuffer(byte[] buffer, int offset) {
		int current=offset;
		current=Message.writeRALongToBuffer(buffer, current, _tag);
		current=Message.writeRAStringToBuffer(buffer, current, _key);
		return current;
	}

}
