/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RAString.java,v 1.5 2005/04/05 15:48:57 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

/**
 * Insert the type's description here.
 * Creation date: (10/31/00 8:06:17 PM)
 * @author:
 */
public class RAString implements Constants {

	protected String _data="";
	protected int _padding=0;
/**
 * RAString constructor comment.
 */
public RAString() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (10/31/00 8:07:25 PM)
 * @param data java.lang.String
 */
public RAString(String data) {
	if(data!=null) {
		_data=data;
		calculatePadding();
	}
	else {
		_data="";
		_padding=0;
	}
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/00 10:18:58 PM)
 */
private void calculatePadding() {
	try {
		_padding=4-_data.getBytes("UTF-8").length%4;
		if(_padding==4) {
			_padding=0;
		}
	}
	catch(Exception e) {
		_padding=4-_data.length()%4;
		if(_padding==4) {
			_padding=0;
		}	
	}
}
/**
 * Insert the method's description here.
 * Creation date: (10/31/00 8:08:17 PM)
 * @return java.lang.String
 */
public String getData() {
	return _data;
}
/**
 * Insert the method's description here.
 * Creation date: (10/31/00 8:08:30 PM)
 * @return int
 */
public int getPadding() {
	return _padding;
}
/**
 * Insert the method's description here.
 * Creation date: (10/31/00 8:12:24 PM)
 * @return long
 */
public int getSize() {
	try {
		return sizeofLong+_data.getBytes("UTF-8").length+_padding;
	}
	catch(Throwable e) {
		return sizeofLong+_data.length()+_padding;
	}
}
/**
 * Insert the method's description here.
 * Creation date: (10/31/00 8:09:17 PM)
 * @return long
 */
public long length() {
	if(_data!=null)
		return _data.length();

	return 0;
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/00 5:17:34 PM)
 * @param data java.lang.String
 */
public void setData(String data) {
	_data=data;
	calculatePadding();
}
}
