/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Connection.java,v 1.6 2005/02/16 22:20:16 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.security.AuthenticationListener;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;

public interface Connection {
	
	void sendMessage(ControlMessage msg, CommandHandler handler) throws IOException;
	
	void disconnect();
	
	Node getNode();

	boolean isActive();
	
	int getPort();
	
	
	/**
	 * Adds a ConnectionListener to this Connection instance.
	 * @see ConnectionListener
	 */
	void addConnectionListener(ConnectionListener listener);
	
	/**
	 * Removes a ConnectionListener from this Connection instance.
	 * @see ConnectionListener
	 */
	void removeConnectionListener(ConnectionListener listener);
	
	
	/**
	 * Adds an AuthenticationListener to this connection.
	 * @see AuthenticationListener
	 */
	void addAuthenticationListener(AuthenticationListener listener);
	
	/**
	 * Removes an AuthenticationListener from this connection.
	 * @see AuthenticationListener
	 */
	void removeAuthenticationListener(AuthenticationListener listener);
	
	void connect(Node node, int port) throws IOException,SecureConnectionRequiredException, LoginFailedException,	UntrustedAgentControllerException;

}

