/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ContextMapper.java,v 1.5 2005/06/03 03:18:54 sschneid Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.control;

public class ContextMapper {
	protected final static int MAPPING_INCREMENT =10;

	protected ContextMap[] _map=new ContextMap[MAPPING_INCREMENT];
	protected int _mappingCount=0;
	protected int _maxMappingCount=0;
	
	private boolean DEBUG = false;
	
    {
        if (DEBUG) {
	        Thread monitor = 
		        new Thread() {
		            public void run() {
		                while (true) {
		                    try {
		                        synchronized (this) {
		                            this.wait(30000);
		                        }
		                    } catch (InterruptedException e) {
		                        // Handling not necessary
		                    }
		                    System.err.println("====================================================================================");
		                    System.err.println("[" + ContextMapper.this._map.length + " items in the context mapper map");
		                    
		                    for (int i=0; i<ContextMapper.this._mappingCount; i++) {
		                        System.err.println(_map[i]._context + " -> " +_map[i]._handler);
		                    }
		                   
		                    System.err.println("====================================================================================");
		                }
		            }
		        };
		        monitor.setName("ContextMapper Monitor");
		        monitor.setDaemon(true);
		        monitor.start();
        }
    }
	
	class ContextMap {
		public long _context=0;
		public CommandHandler _handler=null;
		public boolean _dirty=false;
	}

	public ContextMapper() {
		super();
	}

	public void addContext(long contextId, CommandHandler handler) {
		synchronized(_map) {
			if(_maxMappingCount == _map.length) {
				increaseContextmappingCapacity();
			}
			for(int i=_mappingCount; i>=0; i--) {
				if(_map[i]==null) {
					_mappingCount++;
					_maxMappingCount++;
					_map[i]=new ContextMap();
					_map[i]._context=contextId;
					_map[i]._handler=handler;
					_map[i]._dirty=true;
					return;
				}
				else if(!_map[i]._dirty) {
					_mappingCount++;
					_map[i]._context=contextId;
					_map[i]._handler=handler;
					_map[i]._dirty=true;
					return;
				}
			}
		}
	}

	public CommandHandler getHandler(long contextid) {
		CommandHandler ch=null;
		synchronized (_map) {
			for(int i=_maxMappingCount-1; i>=0; i--) {
				if(_map[i]==null) {
					/* This should never happen */
					break;
				}
				if(_map[i]._context==contextid && _map[i]._dirty==true ) {
					ch=_map[i]._handler;
					break;
				}
			}
		}
		return ch;
	}

	protected void increaseContextmappingCapacity() {
		synchronized(_map) {
			ContextMap[] newMapper=new ContextMap[_maxMappingCount+MAPPING_INCREMENT];
			for(int i=0; i<_maxMappingCount; i++) {
				newMapper[i]=_map[i];
			}
			_map=newMapper;
			newMapper=null;
		}
	}

	public void removeContext(long contextId) {
		synchronized (_map) {
			for(int i=_maxMappingCount-1; i>=0; i--) {
				if(_map[i]._context==contextId && _map[i]._dirty==true ) {
					_mappingCount--;
					_map[i]._dirty=false;
					_map[i]._handler=null;
					break;
				}
			}
		}	
	
	}
}
