/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FileTransferTest.java,v 1.7 2005/05/03 14:41:22 sschneid Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.execution.local;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.UnknownHostException;

import org.eclipse.hyades.execution.core.DaemonConnectException;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.UnknownDaemonException;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.local.NodeImpl;

/**
 * @author Giridhar.S To change the template for this generated type comment go
 *         to Window - Preferences - Java - Code Generation - Code and Comments
 */
public class FileTransferTest {

	public static void delete(IFileManager m, String file) {
		try {
			m.deleteFile(file);
		} catch (IOException e) {
		}
	}

	public static void get(IFileManager m, String localFile, String remoteFile) {
		try {
			m.getFile(localFile, remoteFile);
		} catch (IOException e) {
		}
	}

	public static void main(String[] args) {

		INode node = new NodeImpl("win-pagarwal01");

		ISession session = null;

		try {
			session = node.connect("10002", null);
		} catch (UnknownHostException e) {
		} catch (UnknownDaemonException e) {
		} catch (DaemonConnectException e) {
		}

		IFileManager manager = ((NodeImpl) node).getFileManager();

		/* Methods to test functionality of file service */

		int result = 0;

		get(manager, "C:\\temp1.zip", "C:\\temp.zip");
		put(manager, "C:\\trace.trcxml", "C:\\trace1.trcxml");
		delete(manager, "C:\\abcd.trcxml");

		BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));

		/*
		 * try { reader.readLine(); } catch (IOException e1) { }
		 */

		session.release();
	}

	public static void put(IFileManager m, String localFile, String remoteFile) {
		try {
			m.putFile(localFile, remoteFile);
		} catch (IOException e) {
		}
	}
}
