package org.eclipse.hyades.test.execution.local;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Test.java,v 1.5 2005/02/16 22:20:18 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import org.eclipse.hyades.execution.core.IExecutionComponentFactory;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.core.impl.OrderedPropertyImpl;
import org.eclipse.hyades.execution.local.NodeImpl;
import org.eclipse.hyades.execution.local.ExecutionComponentFactoryImpl;

public class Test {


	public void run() {
		/* Create our session */
		//INode node=new NodeImpl("rduggan");
		INode node=new NodeImpl("win-pagarwal01");
		ISession session=null;
		try {
			session=node.connect("10002", null);
			
			IFileManager manager=((NodeImpl)node).getFileManager();
			//manager.getFile("c:\\temp\\transfer.out", "c:\\temp\\regex1.adapter");
			manager.getFile("c:\\temp\\first.trcxml", "c:\\temp\\second.trcxml");
			System.out.println("File transfer complete");
			
		}
		catch(Exception e) {
			System.out.println("Error creating session "+e.getMessage());
			e.printStackTrace();
			return;
		}
		
		try {
		
			// Get our factory 
			IExecutionComponentFactory factory=ExecutionComponentFactoryImpl.getInstance(session);
			
			// Configure our factory to use the proper types 
			factory.addExecutionComponent("ENVIRONMENT", "org.eclipse.hyades.execution.core.impl.ExecutionEnvironmentImpl");
			factory.addStub("ENVIRONMENT", "org.eclipse.hyades.execution.local.ExecutionEnvironmentStub");
			factory.addSkeleton("ENVIRONMENT", "org.eclipse.hyades.execution.remote.ExecutionEnvironmentSkeleton");
			
			factory.addExecutionComponent("EXECUTOR", "org.eclipse.hyades.execution.core.impl.ProcessExecutorImpl");
			factory.addStub("EXECUTOR", "org.eclipse.hyades.execution.local.ExecutorStub");
			factory.addSkeleton("EXECUTOR", "org.eclipse.hyades.execution.remote.ExecutorSkeleton");

			
			// create our environment 
			IExecutionEnvironment exeEnvironment =(IExecutionEnvironment)factory.createExecutionComponentByType("ENVIRONMENT");
			
			session.addChild(exeEnvironment);
			
			OrderedPropertyImpl property=new OrderedPropertyImpl();
			property.setName("PATH");
			property.appendValue("d:\\temp");
			exeEnvironment.addEnv(property);
			
			
			// create our executor 
			IExecutor executor =(IExecutor)factory.createExecutionComponentByType("EXECUTOR");
			
			// Add an executor to the environment 
			exeEnvironment.addChild(executor);
			
			//executor.setExecutableObject(null);
			executor.launch();
		}
		catch(ClassNotFoundException e) {
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
		finally {
			session.release();
		}
	}

	public static void main(String[] args) {
		Test test= new Test();
		test.run();
	}
}
