package org.eclipse.hyades.logging.events.cbe;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EventPackage.java,v 1.3 2005/02/16 22:20:39 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains access methods for the metaobjects to represent:
 * <ul>
 *   <li>Each class</li>
 *   <li>Each feature of each class</li>
 *   <li>Each enum</li>
 *   <li>Each data type</li>
 * </ul>
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.logging.events.cbe.EventFactory
 * @generated
 */
public interface EventPackage extends EPackage {
    /**
     * The package name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNAME = "cbe";

    /**
     * The package namespace URI.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNS_URI = "http://www.ibm.com/AC/commonbaseevent1_0_1";

    /**
     * The package namespace name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNS_PREFIX = "";

    /**
     * The singleton instance of the package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EventPackage eINSTANCE = org.eclipse.hyades.logging.events.cbe.impl.EventPackageImpl.init();

    /**
     * The metaobject ID for the '{@link java.io.Serializable <em>Serializable</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see java.io.Serializable
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getSerializable()
     * @generated
     */
    int SERIALIZABLE = 22;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.AssociatedEvent <em>Associated Event</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.AssociatedEvent
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getAssociatedEvent()
     * @generated
     */
    int ASSOCIATED_EVENT = 0;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.AssociationEngine <em>Association Engine</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.AssociationEngine
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getAssociationEngine()
     * @generated
     */
    int ASSOCIATION_ENGINE = 1;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.SituationType <em>Situation Type</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.SituationType
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getSituationType()
     * @generated
     */
    int SITUATION_TYPE = 19;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.AvailableSituation <em>Available Situation</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.AvailableSituation
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getAvailableSituation()
     * @generated
     */
    int AVAILABLE_SITUATION = 2;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent <em>Common Base Event</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCommonBaseEvent()
     * @generated
     */
    int COMMON_BASE_EVENT = 3;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification <em>Component Identification</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.ComponentIdentification
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getComponentIdentification()
     * @generated
     */
    int COMPONENT_IDENTIFICATION = 4;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.ConfigureSituation <em>Configure Situation</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.ConfigureSituation
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getConfigureSituation()
     * @generated
     */
    int CONFIGURE_SITUATION = 5;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.ConnectSituation <em>Connect Situation</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.ConnectSituation
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getConnectSituation()
     * @generated
     */
    int CONNECT_SITUATION = 6;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.ContextDataElement <em>Context Data Element</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.ContextDataElement
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getContextDataElement()
     * @generated
     */
    int CONTEXT_DATA_ELEMENT = 7;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.CreateSituation <em>Create Situation</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.CreateSituation
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getCreateSituation()
     * @generated
     */
    int CREATE_SITUATION = 8;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.DependencySituation <em>Dependency Situation</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.DependencySituation
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getDependencySituation()
     * @generated
     */
    int DEPENDENCY_SITUATION = 9;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.DestroySituation <em>Destroy Situation</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.DestroySituation
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getDestroySituation()
     * @generated
     */
    int DESTROY_SITUATION = 10;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement <em>Extended Data Element</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getExtendedDataElement()
     * @generated
     */
    int EXTENDED_DATA_ELEMENT = 11;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.FeatureSituation <em>Feature Situation</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.FeatureSituation
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getFeatureSituation()
     * @generated
     */
    int FEATURE_SITUATION = 12;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.MsgCatalogToken <em>Msg Catalog Token</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.MsgCatalogToken
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getMsgCatalogToken()
     * @generated
     */
    int MSG_CATALOG_TOKEN = 13;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement <em>Msg Data Element</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.MsgDataElement
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getMsgDataElement()
     * @generated
     */
    int MSG_DATA_ELEMENT = 14;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.OtherSituation <em>Other Situation</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.OtherSituation
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getOtherSituation()
     * @generated
     */
    int OTHER_SITUATION = 15;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.ReportSituation <em>Report Situation</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.ReportSituation
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getReportSituation()
     * @generated
     */
    int REPORT_SITUATION = 16;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.RequestSituation <em>Request Situation</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.RequestSituation
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getRequestSituation()
     * @generated
     */
    int REQUEST_SITUATION = 17;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.Situation <em>Situation</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.Situation
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getSituation()
     * @generated
     */
    int SITUATION = 18;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.StartSituation <em>Start Situation</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.StartSituation
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getStartSituation()
     * @generated
     */
    int START_SITUATION = 20;

    /**
     * The metaobject ID for the '{@link org.eclipse.hyades.logging.events.cbe.StopSituation <em>Stop Situation</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.hyades.logging.events.cbe.StopSituation
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getStopSituation()
     * @generated
     */
    int STOP_SITUATION = 21;

    /**
     * The number of structural features of the the '<em>Serializable</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int SERIALIZABLE_FEATURE_COUNT = 0;

    /**
     * The feature ID for the '<em><b>Association Engine</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATED_EVENT__ASSOCIATION_ENGINE = SERIALIZABLE_FEATURE_COUNT + 0;

    /**
     * The feature ID for the '<em><b>Resolved Events</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATED_EVENT__RESOLVED_EVENTS = SERIALIZABLE_FEATURE_COUNT + 1;

    /**
     * The feature ID for the '<em><b>Association Engine Info</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATED_EVENT__ASSOCIATION_ENGINE_INFO = SERIALIZABLE_FEATURE_COUNT + 2;

    /**
     * The number of structural features of the the '<em>Associated Event</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATED_EVENT_FEATURE_COUNT = SERIALIZABLE_FEATURE_COUNT + 3;

    /**
     * The feature ID for the '<em><b>Id</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATION_ENGINE__ID = SERIALIZABLE_FEATURE_COUNT + 0;

    /**
     * The feature ID for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATION_ENGINE__NAME = SERIALIZABLE_FEATURE_COUNT + 1;

    /**
     * The feature ID for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATION_ENGINE__TYPE = SERIALIZABLE_FEATURE_COUNT + 2;

    /**
     * The number of structural features of the the '<em>Association Engine</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ASSOCIATION_ENGINE_FEATURE_COUNT = SERIALIZABLE_FEATURE_COUNT + 3;

    /**
     * The feature ID for the '<em><b>Reasoning Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int SITUATION_TYPE__REASONING_SCOPE = SERIALIZABLE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the the '<em>Situation Type</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int SITUATION_TYPE_FEATURE_COUNT = SERIALIZABLE_FEATURE_COUNT + 1;

    /**
     * The feature ID for the '<em><b>Reasoning Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int AVAILABLE_SITUATION__REASONING_SCOPE = SITUATION_TYPE__REASONING_SCOPE;

    /**
     * The feature ID for the '<em><b>Operation Disposition</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int AVAILABLE_SITUATION__OPERATION_DISPOSITION = SITUATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature ID for the '<em><b>Availability Disposition</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int AVAILABLE_SITUATION__AVAILABILITY_DISPOSITION = SITUATION_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature ID for the '<em><b>Processing Disposition</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int AVAILABLE_SITUATION__PROCESSING_DISPOSITION = SITUATION_TYPE_FEATURE_COUNT + 2;

    /**
     * The number of structural features of the the '<em>Available Situation</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int AVAILABLE_SITUATION_FEATURE_COUNT = SITUATION_TYPE_FEATURE_COUNT + 3;

    /**
     * The feature ID for the '<em><b>Creation Time</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__CREATION_TIME = SERIALIZABLE_FEATURE_COUNT + 0;

    /**
     * The feature ID for the '<em><b>Global Instance ID</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__GLOBAL_INSTANCE_ID = SERIALIZABLE_FEATURE_COUNT + 1;

    /**
     * The feature ID for the '<em><b>Elapsed Time</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__ELAPSED_TIME = SERIALIZABLE_FEATURE_COUNT + 2;

    /**
     * The feature ID for the '<em><b>Extension Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__EXTENSION_NAME = SERIALIZABLE_FEATURE_COUNT + 3;

    /**
     * The feature ID for the '<em><b>Local Instance ID</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__LOCAL_INSTANCE_ID = SERIALIZABLE_FEATURE_COUNT + 4;

    /**
     * The feature ID for the '<em><b>Msg</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__MSG = SERIALIZABLE_FEATURE_COUNT + 5;

    /**
     * The feature ID for the '<em><b>Priority</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__PRIORITY = SERIALIZABLE_FEATURE_COUNT + 6;

    /**
     * The feature ID for the '<em><b>Repeat Count</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__REPEAT_COUNT = SERIALIZABLE_FEATURE_COUNT + 7;

    /**
     * The feature ID for the '<em><b>Sequence Number</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__SEQUENCE_NUMBER = SERIALIZABLE_FEATURE_COUNT + 8;

    /**
     * The feature ID for the '<em><b>Severity</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__SEVERITY = SERIALIZABLE_FEATURE_COUNT + 9;

    /**
     * The feature ID for the '<em><b>Version</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__VERSION = SERIALIZABLE_FEATURE_COUNT + 10;

    /**
     * The feature ID for the '<em><b>Any</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__ANY = SERIALIZABLE_FEATURE_COUNT + 11;

    /**
     * The feature ID for the '<em><b>Situation</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__SITUATION = SERIALIZABLE_FEATURE_COUNT + 12;

    /**
     * The feature ID for the '<em><b>Associated Events</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__ASSOCIATED_EVENTS = SERIALIZABLE_FEATURE_COUNT + 13;

    /**
     * The feature ID for the '<em><b>Context Data Elements</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__CONTEXT_DATA_ELEMENTS = SERIALIZABLE_FEATURE_COUNT + 14;

    /**
     * The feature ID for the '<em><b>Extended Data Elements</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__EXTENDED_DATA_ELEMENTS = SERIALIZABLE_FEATURE_COUNT + 15;

    /**
     * The feature ID for the '<em><b>Msg Data Element</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__MSG_DATA_ELEMENT = SERIALIZABLE_FEATURE_COUNT + 16;

    /**
     * The feature ID for the '<em><b>Reporter Component ID</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__REPORTER_COMPONENT_ID = SERIALIZABLE_FEATURE_COUNT + 17;

    /**
     * The feature ID for the '<em><b>Source Component ID</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT__SOURCE_COMPONENT_ID = SERIALIZABLE_FEATURE_COUNT + 18;

    /**
     * The number of structural features of the the '<em>Common Base Event</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMMON_BASE_EVENT_FEATURE_COUNT = SERIALIZABLE_FEATURE_COUNT + 19;

    /**
     * The feature ID for the '<em><b>Application</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPONENT_IDENTIFICATION__APPLICATION = SERIALIZABLE_FEATURE_COUNT + 0;

    /**
     * The feature ID for the '<em><b>Component</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPONENT_IDENTIFICATION__COMPONENT = SERIALIZABLE_FEATURE_COUNT + 1;

    /**
     * The feature ID for the '<em><b>Component Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPONENT_IDENTIFICATION__COMPONENT_TYPE = SERIALIZABLE_FEATURE_COUNT + 2;

    /**
     * The feature ID for the '<em><b>Component ID Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPONENT_IDENTIFICATION__COMPONENT_ID_TYPE = SERIALIZABLE_FEATURE_COUNT + 3;

    /**
     * The feature ID for the '<em><b>Execution Environment</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPONENT_IDENTIFICATION__EXECUTION_ENVIRONMENT = SERIALIZABLE_FEATURE_COUNT + 4;

    /**
     * The feature ID for the '<em><b>Instance ID</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPONENT_IDENTIFICATION__INSTANCE_ID = SERIALIZABLE_FEATURE_COUNT + 5;

    /**
     * The feature ID for the '<em><b>Location</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPONENT_IDENTIFICATION__LOCATION = SERIALIZABLE_FEATURE_COUNT + 6;

    /**
     * The feature ID for the '<em><b>Location Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPONENT_IDENTIFICATION__LOCATION_TYPE = SERIALIZABLE_FEATURE_COUNT + 7;

    /**
     * The feature ID for the '<em><b>Process ID</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPONENT_IDENTIFICATION__PROCESS_ID = SERIALIZABLE_FEATURE_COUNT + 8;

    /**
     * The feature ID for the '<em><b>Sub Component</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPONENT_IDENTIFICATION__SUB_COMPONENT = SERIALIZABLE_FEATURE_COUNT + 9;

    /**
     * The feature ID for the '<em><b>Thread ID</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPONENT_IDENTIFICATION__THREAD_ID = SERIALIZABLE_FEATURE_COUNT + 10;

    /**
     * The number of structural features of the the '<em>Component Identification</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int COMPONENT_IDENTIFICATION_FEATURE_COUNT = SERIALIZABLE_FEATURE_COUNT + 11;

    /**
     * The feature ID for the '<em><b>Reasoning Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONFIGURE_SITUATION__REASONING_SCOPE = SITUATION_TYPE__REASONING_SCOPE;

    /**
     * The feature ID for the '<em><b>Success Disposition</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONFIGURE_SITUATION__SUCCESS_DISPOSITION = SITUATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the the '<em>Configure Situation</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONFIGURE_SITUATION_FEATURE_COUNT = SITUATION_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature ID for the '<em><b>Reasoning Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONNECT_SITUATION__REASONING_SCOPE = SITUATION_TYPE__REASONING_SCOPE;

    /**
     * The feature ID for the '<em><b>Success Disposition</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONNECT_SITUATION__SUCCESS_DISPOSITION = SITUATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature ID for the '<em><b>Situation Disposition</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONNECT_SITUATION__SITUATION_DISPOSITION = SITUATION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the the '<em>Connect Situation</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONNECT_SITUATION_FEATURE_COUNT = SITUATION_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature ID for the '<em><b>Context ID</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTEXT_DATA_ELEMENT__CONTEXT_ID = SERIALIZABLE_FEATURE_COUNT + 0;

    /**
     * The feature ID for the '<em><b>Context Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTEXT_DATA_ELEMENT__CONTEXT_VALUE = SERIALIZABLE_FEATURE_COUNT + 1;

    /**
     * The feature ID for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTEXT_DATA_ELEMENT__NAME = SERIALIZABLE_FEATURE_COUNT + 2;

    /**
     * The feature ID for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTEXT_DATA_ELEMENT__TYPE = SERIALIZABLE_FEATURE_COUNT + 3;

    /**
     * The number of structural features of the the '<em>Context Data Element</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CONTEXT_DATA_ELEMENT_FEATURE_COUNT = SERIALIZABLE_FEATURE_COUNT + 4;

    /**
     * The feature ID for the '<em><b>Reasoning Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CREATE_SITUATION__REASONING_SCOPE = SITUATION_TYPE__REASONING_SCOPE;

    /**
     * The feature ID for the '<em><b>Success Disposition</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CREATE_SITUATION__SUCCESS_DISPOSITION = SITUATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the the '<em>Create Situation</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int CREATE_SITUATION_FEATURE_COUNT = SITUATION_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature ID for the '<em><b>Reasoning Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEPENDENCY_SITUATION__REASONING_SCOPE = SITUATION_TYPE__REASONING_SCOPE;

    /**
     * The feature ID for the '<em><b>Dependency Disposition</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEPENDENCY_SITUATION__DEPENDENCY_DISPOSITION = SITUATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the the '<em>Dependency Situation</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DEPENDENCY_SITUATION_FEATURE_COUNT = SITUATION_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature ID for the '<em><b>Reasoning Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DESTROY_SITUATION__REASONING_SCOPE = SITUATION_TYPE__REASONING_SCOPE;

    /**
     * The feature ID for the '<em><b>Success Disposition</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DESTROY_SITUATION__SUCCESS_DISPOSITION = SITUATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the the '<em>Destroy Situation</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int DESTROY_SITUATION_FEATURE_COUNT = SITUATION_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature ID for the '<em><b>Hex Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EXTENDED_DATA_ELEMENT__HEX_VALUE = SERIALIZABLE_FEATURE_COUNT + 0;

    /**
     * The feature ID for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EXTENDED_DATA_ELEMENT__NAME = SERIALIZABLE_FEATURE_COUNT + 1;

    /**
     * The feature ID for the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EXTENDED_DATA_ELEMENT__TYPE = SERIALIZABLE_FEATURE_COUNT + 2;

    /**
     * The feature ID for the '<em><b>Values</b></em>' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EXTENDED_DATA_ELEMENT__VALUES = SERIALIZABLE_FEATURE_COUNT + 3;

    /**
     * The feature ID for the '<em><b>Children</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EXTENDED_DATA_ELEMENT__CHILDREN = SERIALIZABLE_FEATURE_COUNT + 4;

    /**
     * The number of structural features of the the '<em>Extended Data Element</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int EXTENDED_DATA_ELEMENT_FEATURE_COUNT = SERIALIZABLE_FEATURE_COUNT + 5;

    /**
     * The feature ID for the '<em><b>Reasoning Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_SITUATION__REASONING_SCOPE = SITUATION_TYPE__REASONING_SCOPE;

    /**
     * The feature ID for the '<em><b>Feature Disposition</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_SITUATION__FEATURE_DISPOSITION = SITUATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the the '<em>Feature Situation</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FEATURE_SITUATION_FEATURE_COUNT = SITUATION_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature ID for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MSG_CATALOG_TOKEN__VALUE = SERIALIZABLE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the the '<em>Msg Catalog Token</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MSG_CATALOG_TOKEN_FEATURE_COUNT = SERIALIZABLE_FEATURE_COUNT + 1;

    /**
     * The feature ID for the '<em><b>Msg ID Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MSG_DATA_ELEMENT__MSG_ID_TYPE = SERIALIZABLE_FEATURE_COUNT + 0;

    /**
     * The feature ID for the '<em><b>Msg Catalog Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MSG_DATA_ELEMENT__MSG_CATALOG_TYPE = SERIALIZABLE_FEATURE_COUNT + 1;

    /**
     * The feature ID for the '<em><b>Msg Catalog</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MSG_DATA_ELEMENT__MSG_CATALOG = SERIALIZABLE_FEATURE_COUNT + 2;

    /**
     * The feature ID for the '<em><b>Msg Catalog ID</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MSG_DATA_ELEMENT__MSG_CATALOG_ID = SERIALIZABLE_FEATURE_COUNT + 3;

    /**
     * The feature ID for the '<em><b>Msg ID</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MSG_DATA_ELEMENT__MSG_ID = SERIALIZABLE_FEATURE_COUNT + 4;

    /**
     * The feature ID for the '<em><b>Msg Locale</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MSG_DATA_ELEMENT__MSG_LOCALE = SERIALIZABLE_FEATURE_COUNT + 5;

    /**
     * The feature ID for the '<em><b>Msg Catalog Tokens</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MSG_DATA_ELEMENT__MSG_CATALOG_TOKENS = SERIALIZABLE_FEATURE_COUNT + 6;

    /**
     * The number of structural features of the the '<em>Msg Data Element</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int MSG_DATA_ELEMENT_FEATURE_COUNT = SERIALIZABLE_FEATURE_COUNT + 7;

    /**
     * The feature ID for the '<em><b>Reasoning Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OTHER_SITUATION__REASONING_SCOPE = SITUATION_TYPE__REASONING_SCOPE;

    /**
     * The feature ID for the '<em><b>Any</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OTHER_SITUATION__ANY = SITUATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the the '<em>Other Situation</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int OTHER_SITUATION_FEATURE_COUNT = SITUATION_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature ID for the '<em><b>Reasoning Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int REPORT_SITUATION__REASONING_SCOPE = SITUATION_TYPE__REASONING_SCOPE;

    /**
     * The feature ID for the '<em><b>Report Category</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int REPORT_SITUATION__REPORT_CATEGORY = SITUATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the the '<em>Report Situation</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int REPORT_SITUATION_FEATURE_COUNT = SITUATION_TYPE_FEATURE_COUNT + 1;

    /**
     * The feature ID for the '<em><b>Reasoning Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int REQUEST_SITUATION__REASONING_SCOPE = SITUATION_TYPE__REASONING_SCOPE;

    /**
     * The feature ID for the '<em><b>Success Disposition</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int REQUEST_SITUATION__SUCCESS_DISPOSITION = SITUATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature ID for the '<em><b>Situation Qualifier</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int REQUEST_SITUATION__SITUATION_QUALIFIER = SITUATION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the the '<em>Request Situation</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int REQUEST_SITUATION_FEATURE_COUNT = SITUATION_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature ID for the '<em><b>Category Name</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int SITUATION__CATEGORY_NAME = SERIALIZABLE_FEATURE_COUNT + 0;

    /**
     * The feature ID for the '<em><b>Situation Type</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int SITUATION__SITUATION_TYPE = SERIALIZABLE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the the '<em>Situation</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int SITUATION_FEATURE_COUNT = SERIALIZABLE_FEATURE_COUNT + 2;

    /**
     * The feature ID for the '<em><b>Reasoning Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int START_SITUATION__REASONING_SCOPE = SITUATION_TYPE__REASONING_SCOPE;

    /**
     * The feature ID for the '<em><b>Success Disposition</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int START_SITUATION__SUCCESS_DISPOSITION = SITUATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature ID for the '<em><b>Situation Qualifier</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int START_SITUATION__SITUATION_QUALIFIER = SITUATION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the the '<em>Start Situation</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int START_SITUATION_FEATURE_COUNT = SITUATION_TYPE_FEATURE_COUNT + 2;

    /**
     * The feature ID for the '<em><b>Reasoning Scope</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int STOP_SITUATION__REASONING_SCOPE = SITUATION_TYPE__REASONING_SCOPE;

    /**
     * The feature ID for the '<em><b>Success Disposition</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int STOP_SITUATION__SUCCESS_DISPOSITION = SITUATION_TYPE_FEATURE_COUNT + 0;

    /**
     * The feature ID for the '<em><b>Situation Qualifier</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int STOP_SITUATION__SITUATION_QUALIFIER = SITUATION_TYPE_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the the '<em>Stop Situation</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int STOP_SITUATION_FEATURE_COUNT = SITUATION_TYPE_FEATURE_COUNT + 2;

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.AssociatedEvent <em>Associated Event</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Associated Event</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.AssociatedEvent
     * @generated
     */
    EClass getAssociatedEvent();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.AssociatedEvent#getAssociationEngine <em>Association Engine</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Association Engine</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.AssociatedEvent#getAssociationEngine()
     * @see #getAssociatedEvent()
     * @generated
     */
    EAttribute getAssociatedEvent_AssociationEngine();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.AssociatedEvent#getResolvedEvents <em>Resolved Events</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Resolved Events</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.AssociatedEvent#getResolvedEvents()
     * @see #getAssociatedEvent()
     * @generated
     */
    EAttribute getAssociatedEvent_ResolvedEvents();

    /**
     * Returns the metaobject for the containment reference '{@link org.eclipse.hyades.logging.events.cbe.AssociatedEvent#getAssociationEngineInfo <em>Association Engine Info</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the containment reference '<em>Association Engine Info</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.AssociatedEvent#getAssociationEngineInfo()
     * @see #getAssociatedEvent()
     * @generated
     */
    EReference getAssociatedEvent_AssociationEngineInfo();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.AssociationEngine <em>Association Engine</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Association Engine</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.AssociationEngine
     * @generated
     */
    EClass getAssociationEngine();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.AssociationEngine#getId <em>Id</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Id</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.AssociationEngine#getId()
     * @see #getAssociationEngine()
     * @generated
     */
    EAttribute getAssociationEngine_Id();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.AssociationEngine#getName <em>Name</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Name</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.AssociationEngine#getName()
     * @see #getAssociationEngine()
     * @generated
     */
    EAttribute getAssociationEngine_Name();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.AssociationEngine#getType <em>Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Type</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.AssociationEngine#getType()
     * @see #getAssociationEngine()
     * @generated
     */
    EAttribute getAssociationEngine_Type();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.AvailableSituation <em>Available Situation</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Available Situation</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.AvailableSituation
     * @generated
     */
    EClass getAvailableSituation();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.AvailableSituation#getOperationDisposition <em>Operation Disposition</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Operation Disposition</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.AvailableSituation#getOperationDisposition()
     * @see #getAvailableSituation()
     * @generated
     */
    EAttribute getAvailableSituation_OperationDisposition();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.AvailableSituation#getAvailabilityDisposition <em>Availability Disposition</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Availability Disposition</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.AvailableSituation#getAvailabilityDisposition()
     * @see #getAvailableSituation()
     * @generated
     */
    EAttribute getAvailableSituation_AvailabilityDisposition();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.AvailableSituation#getProcessingDisposition <em>Processing Disposition</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Processing Disposition</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.AvailableSituation#getProcessingDisposition()
     * @see #getAvailableSituation()
     * @generated
     */
    EAttribute getAvailableSituation_ProcessingDisposition();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent <em>Common Base Event</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Common Base Event</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent
     * @generated
     */
    EClass getCommonBaseEvent();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getCreationTime <em>Creation Time</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Creation Time</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getCreationTime()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EAttribute getCommonBaseEvent_CreationTime();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getGlobalInstanceId <em>Global Instance ID</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Global Instance ID</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getGlobalInstanceId()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EAttribute getCommonBaseEvent_GlobalInstanceId();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getElapsedTime <em>Elapsed Time</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Elapsed Time</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getElapsedTime()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EAttribute getCommonBaseEvent_ElapsedTime();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getExtensionName <em>Extension Name</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Extension Name</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getExtensionName()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EAttribute getCommonBaseEvent_ExtensionName();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getLocalInstanceId <em>Local Instance ID</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Local Instance ID</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getLocalInstanceId()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EAttribute getCommonBaseEvent_LocalInstanceId();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getMsg <em>Msg</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Msg</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getMsg()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EAttribute getCommonBaseEvent_Msg();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getPriority <em>Priority</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Priority</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getPriority()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EAttribute getCommonBaseEvent_Priority();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getRepeatCount <em>Repeat Count</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Repeat Count</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getRepeatCount()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EAttribute getCommonBaseEvent_RepeatCount();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getSequenceNumber <em>Sequence Number</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Sequence Number</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getSequenceNumber()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EAttribute getCommonBaseEvent_SequenceNumber();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getSeverity <em>Severity</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Severity</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getSeverity()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EAttribute getCommonBaseEvent_Severity();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getVersion <em>Version</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Version</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getVersion()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EAttribute getCommonBaseEvent_Version();

    /**
     * Returns the metaobject for the containment reference '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getSituation <em>Situation</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the containment reference '<em>Situation</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getSituation()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EReference getCommonBaseEvent_Situation();

    /**
     * Returns the metaobject for the attribute list '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getAny <em>Any</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute list '<em>Any</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getAny()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EAttribute getCommonBaseEvent_Any();

    /**
     * Returns the metaobject for the containment reference list '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getAssociatedEvents <em>Associated Events</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the containment reference list '<em>Associated Events</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getAssociatedEvents()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EReference getCommonBaseEvent_AssociatedEvents();

    /**
     * Returns the metaobject for the containment reference list '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getContextDataElements <em>Context Data Elements</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the containment reference list '<em>Context Data Elements</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getContextDataElements()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EReference getCommonBaseEvent_ContextDataElements();

    /**
     * Returns the metaobject for the containment reference list '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getExtendedDataElements <em>Extended Data Elements</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the containment reference list '<em>Extended Data Elements</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getExtendedDataElements()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EReference getCommonBaseEvent_ExtendedDataElements();

    /**
     * Returns the metaobject for the containment reference '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getMsgDataElement <em>Msg Data Element</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the containment reference '<em>Msg Data Element</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getMsgDataElement()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EReference getCommonBaseEvent_MsgDataElement();

    /**
     * Returns the metaobject for the containment reference '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getReporterComponentId <em>Reporter Component ID</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the containment reference '<em>Reporter Component ID</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getReporterComponentId()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EReference getCommonBaseEvent_ReporterComponentId();

    /**
     * Returns the metaobject for the containment reference '{@link org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getSourceComponentId <em>Source Component ID</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the containment reference '<em>Source Component ID</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getSourceComponentId()
     * @see #getCommonBaseEvent()
     * @generated
     */
    EReference getCommonBaseEvent_SourceComponentId();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification <em>Component Identification</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Component Identification</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ComponentIdentification
     * @generated
     */
    EClass getComponentIdentification();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getApplication <em>Application</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Application</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getApplication()
     * @see #getComponentIdentification()
     * @generated
     */
    EAttribute getComponentIdentification_Application();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getComponent <em>Component</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Component</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getComponent()
     * @see #getComponentIdentification()
     * @generated
     */
    EAttribute getComponentIdentification_Component();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getComponentType <em>Component Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Component Type</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getComponentType()
     * @see #getComponentIdentification()
     * @generated
     */
    EAttribute getComponentIdentification_ComponentType();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getComponentIdType <em>Component ID Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Component ID Type</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getComponentIdType()
     * @see #getComponentIdentification()
     * @generated
     */
    EAttribute getComponentIdentification_ComponentIdType();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getExecutionEnvironment <em>Execution Environment</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Execution Environment</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getExecutionEnvironment()
     * @see #getComponentIdentification()
     * @generated
     */
    EAttribute getComponentIdentification_ExecutionEnvironment();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getInstanceId <em>Instance ID</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Instance ID</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getInstanceId()
     * @see #getComponentIdentification()
     * @generated
     */
    EAttribute getComponentIdentification_InstanceId();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getLocation <em>Location</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Location</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getLocation()
     * @see #getComponentIdentification()
     * @generated
     */
    EAttribute getComponentIdentification_Location();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getLocationType <em>Location Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Location Type</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getLocationType()
     * @see #getComponentIdentification()
     * @generated
     */
    EAttribute getComponentIdentification_LocationType();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getProcessId <em>Process ID</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Process ID</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getProcessId()
     * @see #getComponentIdentification()
     * @generated
     */
    EAttribute getComponentIdentification_ProcessId();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getSubComponent <em>Sub Component</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Sub Component</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getSubComponent()
     * @see #getComponentIdentification()
     * @generated
     */
    EAttribute getComponentIdentification_SubComponent();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getThreadId <em>Thread ID</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Thread ID</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getThreadId()
     * @see #getComponentIdentification()
     * @generated
     */
    EAttribute getComponentIdentification_ThreadId();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.ConfigureSituation <em>Configure Situation</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Configure Situation</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ConfigureSituation
     * @generated
     */
    EClass getConfigureSituation();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ConfigureSituation#getSuccessDisposition <em>Success Disposition</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Success Disposition</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ConfigureSituation#getSuccessDisposition()
     * @see #getConfigureSituation()
     * @generated
     */
    EAttribute getConfigureSituation_SuccessDisposition();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.ConnectSituation <em>Connect Situation</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Connect Situation</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ConnectSituation
     * @generated
     */
    EClass getConnectSituation();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ConnectSituation#getSuccessDisposition <em>Success Disposition</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Success Disposition</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ConnectSituation#getSuccessDisposition()
     * @see #getConnectSituation()
     * @generated
     */
    EAttribute getConnectSituation_SuccessDisposition();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ConnectSituation#getSituationDisposition <em>Situation Disposition</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Situation Disposition</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ConnectSituation#getSituationDisposition()
     * @see #getConnectSituation()
     * @generated
     */
    EAttribute getConnectSituation_SituationDisposition();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.ContextDataElement <em>Context Data Element</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Context Data Element</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ContextDataElement
     * @generated
     */
    EClass getContextDataElement();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ContextDataElement#getContextId <em>Context ID</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Context ID</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ContextDataElement#getContextId()
     * @see #getContextDataElement()
     * @generated
     */
    EAttribute getContextDataElement_ContextId();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ContextDataElement#getContextValue <em>Context Value</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Context Value</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ContextDataElement#getContextValue()
     * @see #getContextDataElement()
     * @generated
     */
    EAttribute getContextDataElement_ContextValue();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ContextDataElement#getName <em>Name</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Name</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ContextDataElement#getName()
     * @see #getContextDataElement()
     * @generated
     */
    EAttribute getContextDataElement_Name();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ContextDataElement#getType <em>Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Type</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ContextDataElement#getType()
     * @see #getContextDataElement()
     * @generated
     */
    EAttribute getContextDataElement_Type();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.CreateSituation <em>Create Situation</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Create Situation</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CreateSituation
     * @generated
     */
    EClass getCreateSituation();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.CreateSituation#getSuccessDisposition <em>Success Disposition</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Success Disposition</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.CreateSituation#getSuccessDisposition()
     * @see #getCreateSituation()
     * @generated
     */
    EAttribute getCreateSituation_SuccessDisposition();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.DependencySituation <em>Dependency Situation</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Dependency Situation</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.DependencySituation
     * @generated
     */
    EClass getDependencySituation();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.DependencySituation#getDependencyDisposition <em>Dependency Disposition</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Dependency Disposition</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.DependencySituation#getDependencyDisposition()
     * @see #getDependencySituation()
     * @generated
     */
    EAttribute getDependencySituation_DependencyDisposition();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.DestroySituation <em>Destroy Situation</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Destroy Situation</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.DestroySituation
     * @generated
     */
    EClass getDestroySituation();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.DestroySituation#getSuccessDisposition <em>Success Disposition</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Success Disposition</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.DestroySituation#getSuccessDisposition()
     * @see #getDestroySituation()
     * @generated
     */
    EAttribute getDestroySituation_SuccessDisposition();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement <em>Extended Data Element</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Extended Data Element</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement
     * @generated
     */
    EClass getExtendedDataElement();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getHexValue <em>Hex Value</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Hex Value</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getHexValue()
     * @see #getExtendedDataElement()
     * @generated
     */
    EAttribute getExtendedDataElement_HexValue();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getName <em>Name</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Name</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getName()
     * @see #getExtendedDataElement()
     * @generated
     */
    EAttribute getExtendedDataElement_Name();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getType <em>Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Type</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getType()
     * @see #getExtendedDataElement()
     * @generated
     */
    EAttribute getExtendedDataElement_Type();

    /**
     * Returns the metaobject for the attribute list '{@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValues <em>Values</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute list '<em>Values</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValues()
     * @see #getExtendedDataElement()
     * @generated
     */
    EAttribute getExtendedDataElement_Values();

    /**
     * Returns the metaobject for the containment reference list '{@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getChildren <em>Children</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the containment reference list '<em>Children</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getChildren()
     * @see #getExtendedDataElement()
     * @generated
     */
    EReference getExtendedDataElement_Children();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.FeatureSituation <em>Feature Situation</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Feature Situation</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.FeatureSituation
     * @generated
     */
    EClass getFeatureSituation();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.FeatureSituation#getFeatureDisposition <em>Feature Disposition</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Feature Disposition</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.FeatureSituation#getFeatureDisposition()
     * @see #getFeatureSituation()
     * @generated
     */
    EAttribute getFeatureSituation_FeatureDisposition();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.MsgCatalogToken <em>Msg Catalog Token</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Msg Catalog Token</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.MsgCatalogToken
     * @generated
     */
    EClass getMsgCatalogToken();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.MsgCatalogToken#getValue <em>Value</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Value</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.MsgCatalogToken#getValue()
     * @see #getMsgCatalogToken()
     * @generated
     */
    EAttribute getMsgCatalogToken_Value();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement <em>Msg Data Element</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Msg Data Element</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.MsgDataElement
     * @generated
     */
    EClass getMsgDataElement();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgIdType <em>Msg ID Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Msg ID Type</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgIdType()
     * @see #getMsgDataElement()
     * @generated
     */
    EAttribute getMsgDataElement_MsgIdType();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgCatalogType <em>Msg Catalog Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Msg Catalog Type</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgCatalogType()
     * @see #getMsgDataElement()
     * @generated
     */
    EAttribute getMsgDataElement_MsgCatalogType();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgCatalog <em>Msg Catalog</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Msg Catalog</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgCatalog()
     * @see #getMsgDataElement()
     * @generated
     */
    EAttribute getMsgDataElement_MsgCatalog();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgCatalogId <em>Msg Catalog ID</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Msg Catalog ID</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgCatalogId()
     * @see #getMsgDataElement()
     * @generated
     */
    EAttribute getMsgDataElement_MsgCatalogId();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgId <em>Msg ID</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Msg ID</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgId()
     * @see #getMsgDataElement()
     * @generated
     */
    EAttribute getMsgDataElement_MsgId();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgLocale <em>Msg Locale</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Msg Locale</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgLocale()
     * @see #getMsgDataElement()
     * @generated
     */
    EAttribute getMsgDataElement_MsgLocale();

    /**
     * Returns the metaobject for the containment reference list '{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgCatalogTokens <em>Msg Catalog Tokens</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the containment reference list '<em>Msg Catalog Tokens</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgCatalogTokens()
     * @see #getMsgDataElement()
     * @generated
     */
    EReference getMsgDataElement_MsgCatalogTokens();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.OtherSituation <em>Other Situation</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Other Situation</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.OtherSituation
     * @generated
     */
    EClass getOtherSituation();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.OtherSituation#getAny <em>Any</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Any</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.OtherSituation#getAny()
     * @see #getOtherSituation()
     * @generated
     */
    EAttribute getOtherSituation_Any();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.ReportSituation <em>Report Situation</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Report Situation</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ReportSituation
     * @generated
     */
    EClass getReportSituation();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.ReportSituation#getReportCategory <em>Report Category</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Report Category</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.ReportSituation#getReportCategory()
     * @see #getReportSituation()
     * @generated
     */
    EAttribute getReportSituation_ReportCategory();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.RequestSituation <em>Request Situation</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Request Situation</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.RequestSituation
     * @generated
     */
    EClass getRequestSituation();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.RequestSituation#getSuccessDisposition <em>Success Disposition</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Success Disposition</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.RequestSituation#getSuccessDisposition()
     * @see #getRequestSituation()
     * @generated
     */
    EAttribute getRequestSituation_SuccessDisposition();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.RequestSituation#getSituationQualifier <em>Situation Qualifier</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Situation Qualifier</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.RequestSituation#getSituationQualifier()
     * @see #getRequestSituation()
     * @generated
     */
    EAttribute getRequestSituation_SituationQualifier();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.Situation <em>Situation</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Situation</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.Situation
     * @generated
     */
    EClass getSituation();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.Situation#getCategoryName <em>Category Name</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Category Name</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.Situation#getCategoryName()
     * @see #getSituation()
     * @generated
     */
    EAttribute getSituation_CategoryName();

    /**
     * Returns the metaobject for the containment reference '{@link org.eclipse.hyades.logging.events.cbe.Situation#getSituationType <em>Situation Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the containment reference '<em>Situation Type</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.Situation#getSituationType()
     * @see #getSituation()
     * @generated
     */
    EReference getSituation_SituationType();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.SituationType <em>Situation Type</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Situation Type</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.SituationType
     * @generated
     */
    EClass getSituationType();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.SituationType#getReasoningScope <em>Reasoning Scope</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Reasoning Scope</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.SituationType#getReasoningScope()
     * @see #getSituationType()
     * @generated
     */
    EAttribute getSituationType_ReasoningScope();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.StartSituation <em>Start Situation</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Start Situation</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.StartSituation
     * @generated
     */
    EClass getStartSituation();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.StartSituation#getSuccessDisposition <em>Success Disposition</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Success Disposition</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.StartSituation#getSuccessDisposition()
     * @see #getStartSituation()
     * @generated
     */
    EAttribute getStartSituation_SuccessDisposition();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.StartSituation#getSituationQualifier <em>Situation Qualifier</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Situation Qualifier</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.StartSituation#getSituationQualifier()
     * @see #getStartSituation()
     * @generated
     */
    EAttribute getStartSituation_SituationQualifier();

    /**
     * Returns the metaobject for class '{@link org.eclipse.hyades.logging.events.cbe.StopSituation <em>Stop Situation</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Stop Situation</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.StopSituation
     * @generated
     */
    EClass getStopSituation();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.StopSituation#getSuccessDisposition <em>Success Disposition</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Success Disposition</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.StopSituation#getSuccessDisposition()
     * @see #getStopSituation()
     * @generated
     */
    EAttribute getStopSituation_SuccessDisposition();

    /**
     * Returns the metaobject for the attribute '{@link org.eclipse.hyades.logging.events.cbe.StopSituation#getSituationQualifier <em>Situation Qualifier</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for the attribute '<em>Situation Qualifier</em>'.
     * @see org.eclipse.hyades.logging.events.cbe.StopSituation#getSituationQualifier()
     * @see #getStopSituation()
     * @generated
     */
    EAttribute getStopSituation_SituationQualifier();

    /**
     * Returns the metaobject for class '{@link java.io.Serializable <em>Serializable</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the metaobject for class '<em>Serializable</em>'.
     * @see java.io.Serializable
     * @model instanceClass="java.io.Serializable" 
     * @generated
     */
    EClass getSerializable();

    /**
     * Returns the factory that creates the instances of the model.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the factory that creates the instances of the model.
     * @generated
     */
    EventFactory getEventFactory();

} //EventPackage
