package org.eclipse.hyades.logging.events.cbe;

import java.io.Serializable;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MsgDataElement.java,v 1.3 2005/02/16 22:20:39 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Msg Data Element</b></em>'.
 * <P>
 * The MsgDataElement represents the data that is used to specify all of the
 * related information that is associated with the message that this event
 * holds.
 * </P>
 *
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgIdType <em>Msg Id Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgCatalogType <em>Msg Catalog Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgCatalog <em>Msg Catalog</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgCatalogId <em>Msg Catalog Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgId <em>Msg Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgLocale <em>Msg Locale</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgCatalogTokens <em>Msg Catalog Tokens</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getMsgDataElement()
 * @model 
 * @generated
 */
public interface MsgDataElement extends EObject, Serializable {
    /**
     * <p>
     * Returns the value of the '<em><b>Msg Id Type</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Msg Id Type</em>' attribute.
     * @see #setMsgIdType(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getMsgDataElement_MsgIdType()
     * @model 
     * @generated
     */
    String getMsgIdType();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgIdType <em>Msg Id Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * Specifies the meaning and format of the msgId.  If the msgId conforms to 
     * or represents a standard or a well-known convention, it is named by this 
     * property.   Examples are: "IBM3.4", "IBM4.4", "IBM3.1.4", "IBM3.4.1", "IBM4.4.1", 
     * and "IBM3.1.4.1".  
     * </P>
     * <P>
     * The nonexclusive reserved keywords include:
     * <UL>
     * <LI>IBM*  (* is as described above)</LI>
     * <LI>JMX</LI>
     * <LI>DottedName</LI>
     * <LI>Unknown</LI>
     * </UL>
     * This is an <em>optional</em> property.  The string length for msgIdType <em>must not</em> 
     * exceed 32 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Msg Id Type</em>' attribute.
     * @see #getMsgIdType()
     * @generated
     */
    void setMsgIdType(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Msg Catalog Type</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Msg Catalog Type</em>' attribute.
     * @see #setMsgCatalogType(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getMsgDataElement_MsgCatalogType()
     * @model 
     * @generated
     */
    String getMsgCatalogType();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgCatalogType <em>Msg Catalog Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * The msgCatalogType property specifies the meaning and format of the
     * msgCatalog.  The current nonexclusive list of reserved keywords includes:
     * <UL>
     * <LI>Java</LI>
     * <LI>XPG</LI>
     * </UL>
     * This property is <em>optional</em> and it is not mutable once it is set.  The 
     * string length for the msgCatalogType property <em>must not</em> exceed 32 
     * characters. 
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Msg Catalog Type</em>' attribute.
     * @see #getMsgCatalogType()
     * @generated
     */
    void setMsgCatalogType(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Msg Catalog</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Msg Catalog</em>' attribute.
     * @see #setMsgCatalog(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getMsgDataElement_MsgCatalog()
     * @model 
     * @generated
     */
    String getMsgCatalog();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgCatalog <em>Msg Catalog</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * The qualified name of the message catalog that contains the translated 
     * message specified by the msgCatalogId.
     * </P>
     * <P>
     * This is an <em>optional</em> property.  The string length of the msgCatalog 
     * <em>must not</em> exceed 128 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Msg Catalog</em>' attribute.
     * @see #getMsgCatalog()
     * @generated
     */
    void setMsgCatalog(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Msg Catalog Id</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Msg Catalog Id</em>' attribute.
     * @see #setMsgCatalogId(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getMsgDataElement_MsgCatalogId()
     * @model 
     * @generated
     */
    String getMsgCatalogId();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgCatalogId <em>Msg Catalog Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * The index or the identifier for a message that is used for resolving 
     * the message text from a message catalog.
     * </P>
     * <P>
     * This is an <em>optional</em> property.  The string length for this property 
     * <em>must not</em> exceed 64 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Msg Catalog Id</em>' attribute.
     * @see #getMsgCatalogId()
     * @generated
     */
    void setMsgCatalogId(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Msg Id</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Msg Id</em>' attribute.
     * @see #setMsgId(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getMsgDataElement_MsgId()
     * @model 
     * @generated
     */
    String getMsgId();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgId <em>Msg Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * Specifies the message identifier of the event.  This identifier should 
     * be a unique value string of alphanumeric or numeric characters.  It can
     * be as simple as a string of numeric characters that identify a message 
     * in a message catalog or a multi-part string of alphanumeric characters 
     * (for example, DBT1234E). 
     * </P>
     * <P>
     * This is an <em>optional</em> property.  The string length for msgId <em>must not</em> 
     * exceed 256 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Msg Id</em>' attribute.
     * @see #getMsgId()
     * @generated
     */
    void setMsgId(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Msg Locale</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Msg Locale</em>' attribute.
     * @see #setMsgLocale(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getMsgDataElement_MsgLocale()
     * @model 
     * @generated
     */
    String getMsgLocale();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgLocale <em>Msg Locale</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * The locale for which this msg property is rendered.  Its value is a 
     * locale code that conforms to IETF RFC 1766. 
     * </P>
     * <P>
     * This is an <em>optional</em> property.  
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Msg Locale</em>' attribute.
     * @see #getMsgLocale()
     * @generated
     */
    void setMsgLocale(String value);

    /**
     * Returns the value of the '<em><b>Msg Catalog Tokens</b></em>' containment reference list.
     * The list contents are of type {@link org.eclipse.hyades.logging.events.cbe.MsgCatalogToken}.
     * <!-- begin-user-doc -->
     * <p>
     * An array of strings used as substitution values for resolving an 
     * internationalized message into formatted text.  The order of the 
     * substitution values is implied by the implicit order of the array 
     * elements.
     * </P>
     * <P>
     * If there are no substitution values, then msgCatalogTokens does not need 
     * to be specified.
     * </P>
     * <P>
     * This is an <em>optional</em> property.  The string length for the 
     * msgCatalogTokens property <em>must not</em> exceed 256 characters per token.
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Msg Catalog Tokens</em>' containment reference list.
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getMsgDataElement_MsgCatalogTokens()
     * @model type="org.eclipse.hyades.logging.events.cbe.MsgCatalogToken" containment="true"
     * @generated
     */
    EList getMsgCatalogTokens();

    /**
     * Adds a new <code>MsgCatalogToken</code> to this object.
     * <p>
     * It creates a <code>MsgCatalogToken</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param value          the <code>String</code> value for the new message
     *                       catalog token.
     *
     * @return               a reference to the message catalog token added
     *                       to this object.
     *
     * @see MsgCatalogToken
     */
    MsgCatalogToken addMsgCatalogTokenAsString(String value);

    /**
     * Adds a new <code>MsgCatalogToken</code> to this object.
     * <p>
     * It creates a <code>MsgCatalogToken</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param value          the <code>MsgCatalogToken</code> value.
     *
     * @return               a reference to the message catalog token added
     *                       to this object.
     *
     * @see MsgCatalogToken
     */
    MsgCatalogToken addMsgCatalogToken(MsgCatalogToken value);

	/**
	 * Removes all msgCatalogTokens that this event is referencing 
	 */
	void clearMsgCatalogTokens();

    /**
     * Returns the value of the '<em><b>Msg Catalog Tokens</b></em>' attribute
     * list.
     * <P>
     * Each string corresponds to the <code>value</code> attribute of a
     * <code>MsgCatalogToken</code> inside the message catalog token list.
     * </p>
     * @return the value of the '<em>Msg Catalog Tokens</em>' attribute list.
     *
     * @see #getMsgCatalogTokens()
     * @see #setMsgCatalogTokensAsStrings(String[])
     */
    String[] getMsgCatalogTokensAsStrings();

    /**
     * Sets the value of the '<em><b>Msg Catalog Tokens</b></em>' attribute
     * list.
     * <P>
     * Each string is translated to the <code>value</code> attribute of a
     * <code>MsgCatalogToken</code> to be added to the message catalog token
     * list.
     * </p>
     * <P>
     * Any prior message catalog token is removed before the new list is set.
     * </p>
     *
     * @param msgCatalogTokens
     *                       array of values for the message catalog tokens
     *
     * @see #getMsgCatalogTokens()
     * @see #getMsgCatalogTokensAsStrings()
     */
    void setMsgCatalogTokensAsStrings(String[] msgCatalogTokens);

    /**
     * Sets the value of the '<em><b>Msg Catalog Tokens</b></em>' attribute
     * list.
     * <P>
     * Each string is translated to the <code>value</code> attribute of a
     * <code>MsgCatalogToken</code> to be added to the message catalog token
     * list.
     * </p>
     * <P>
     * Any prior message catalog token is removed before the new list is set.
     * </p>
     *
     * @param msgCatalogTokens
     *                       array of values for the message catalog tokens
     *
     * @see #getMsgCatalogTokens()
     * @see #getMsgCatalogTokensAsStrings()
     */
    void setMsgCatalogTokens(MsgCatalogToken[] msgCatalogTokens);

    /**
     * <p>
     * Checks whether the contents of this object conforms to the
     * CBE specification.
     * </p>
     *
     * @throws ValidationException
     *                       if the object does not follow the
     *                       CBE specification.
     */
    void validate() throws ValidationException;

	/**
	 * Resets the object's properties to their initial (e.g. null) state.
	 * 
	 * All components are initialized to either zero or null.
	 * 
	 * @since 1.0
	 */
	void init();
}
