package org.eclipse.hyades.logging.events.cbe.impl;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ComponentIdentificationImpl.java,v 1.9 2005/02/16 22:20:39 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.util.Arrays;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;
import org.eclipse.hyades.logging.events.cbe.util.EventValidation;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Component Identification</b></em>'.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0 
 * @implements Cloneable
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ComponentIdentificationImpl#getApplication <em>Application</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ComponentIdentificationImpl#getComponent <em>Component</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ComponentIdentificationImpl#getComponentType <em>Component Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ComponentIdentificationImpl#getComponentIdType <em>Component Id Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ComponentIdentificationImpl#getExecutionEnvironment <em>Execution Environment</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ComponentIdentificationImpl#getInstanceId <em>Instance Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ComponentIdentificationImpl#getLocation <em>Location</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ComponentIdentificationImpl#getLocationType <em>Location Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ComponentIdentificationImpl#getProcessId <em>Process Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ComponentIdentificationImpl#getSubComponent <em>Sub Component</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ComponentIdentificationImpl#getThreadId <em>Thread Id</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ComponentIdentificationImpl extends SerializableImpl implements ComponentIdentification, Cloneable {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = 6775338617504967755L;

    /**
     * Classname for trace/log 
     */
    private static final String CLASS_NAME = ComponentIdentificationImpl.class.getName();

    /**
     * Array of location types for the component identification.
     * 
     * @see #getLocationType()
     */
    static final String[] LOCATION_TYPES = { LOCATION_TYPE_UNKNOWN, LOCATION_TYPE_IPV4, LOCATION_TYPE_IPV6, LOCATION_TYPE_NWA, LOCATION_TYPE_ISDN, LOCATION_TYPE_ICD, LOCATION_TYPE_OID_OSI, LOCATION_TYPE_DIAL, LOCATION_TYPE_HWA, LOCATION_TYPE_HID, LOCATION_TYPE_X25, LOCATION_TYPE_DCC, LOCATION_TYPE_SNA, LOCATION_TYPE_IPX, LOCATION_TYPE_E_164, LOCATION_TYPE_HOSTNAME, LOCATION_TYPE_FQ_HOSTNAME, LOCATION_TYPE_DEVICE_NAME };

    static final List LOCATION_TYPES_LIST = Arrays.asList(LOCATION_TYPES);

    /**
     * The default value of the '{@link #getApplication() <em>Application</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getApplication()
     * @generated
     * @ordered
     */
    protected static final String APPLICATION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getApplication() <em>Application</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getApplication()
     * @generated
     * @ordered
     */
    protected String application = APPLICATION_EDEFAULT;

    /**
     * The default value of the '{@link #getComponent() <em>Component</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getComponent()
     * @generated
     * @ordered
     */
    protected static final String COMPONENT_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getComponent() <em>Component</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getComponent()
     * @generated
     * @ordered
     */
    protected String component = COMPONENT_EDEFAULT;

    /**
     * The default value of the '{@link #getComponentType() <em>Component Type</em>}' attribute.
     * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
     * @see #getComponentType()
     * @generated
     * @ordered
     */
    protected static final String COMPONENT_TYPE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getComponentType() <em>Component Type</em>}' attribute.
     * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
     * @see #getComponentType()
     * @generated
     * @ordered
     */
    protected String componentType = COMPONENT_TYPE_EDEFAULT;

    /**
     * The default value of the '{@link #getComponentIdType() <em>Component Id Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getComponentIdType()
     * @generated
     * @ordered
     */
    protected static final String COMPONENT_ID_TYPE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getComponentIdType() <em>Component Id Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getComponentIdType()
     * @generated
     * @ordered
     */
    protected String componentIdType = COMPONENT_ID_TYPE_EDEFAULT;

    /**
     * The default value of the '{@link #getExecutionEnvironment() <em>Execution Environment</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getExecutionEnvironment()
     * @generated
     * @ordered
     */
    protected static final String EXECUTION_ENVIRONMENT_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getExecutionEnvironment() <em>Execution Environment</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getExecutionEnvironment()
     * @generated
     * @ordered
     */
    protected String executionEnvironment = EXECUTION_ENVIRONMENT_EDEFAULT;

    /**
     * The default value of the '{@link #getInstanceId() <em>Instance Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getInstanceId()
     * @generated
     * @ordered
     */
    protected static final String INSTANCE_ID_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getInstanceId() <em>Instance Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getInstanceId()
     * @generated
     * @ordered
     */
    protected String instanceId = INSTANCE_ID_EDEFAULT;

    /**
     * The default value of the '{@link #getLocation() <em>Location</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLocation()
     * @generated
     * @ordered
     */
    protected static final String LOCATION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getLocation() <em>Location</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLocation()
     * @generated
     * @ordered
     */
    protected String location = LOCATION_EDEFAULT;

    /**
     * The default value of the '{@link #getLocationType() <em>Location Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLocationType()
     * @generated
     * @ordered
     */
    protected static final String LOCATION_TYPE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getLocationType() <em>Location Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLocationType()
     * @generated
     * @ordered
     */
    protected String locationType = LOCATION_TYPE_EDEFAULT;

    /**
     * The default value of the '{@link #getProcessId() <em>Process Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getProcessId()
     * @generated
     * @ordered
     */
    protected static final String PROCESS_ID_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getProcessId() <em>Process Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getProcessId()
     * @generated
     * @ordered
     */
    protected String processId = PROCESS_ID_EDEFAULT;

    /**
     * The default value of the '{@link #getSubComponent() <em>Sub Component</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSubComponent()
     * @generated
     * @ordered
     */
    protected static final String SUB_COMPONENT_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getSubComponent() <em>Sub Component</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSubComponent()
     * @generated
     * @ordered
     */
    protected String subComponent = SUB_COMPONENT_EDEFAULT;

    /**
     * The default value of the '{@link #getThreadId() <em>Thread Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getThreadId()
     * @generated
     * @ordered
     */
    protected static final String THREAD_ID_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getThreadId() <em>Thread Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getThreadId()
     * @generated
     * @ordered
     */
    protected String threadId = THREAD_ID_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ComponentIdentificationImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setApplication(String newApplication) {
        String oldApplication = application;
        application = newApplication;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMPONENT_IDENTIFICATION__APPLICATION, oldApplication, application));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getApplication() {
        return application;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setComponent(String newComponent) {
        String oldComponent = component;
        component = newComponent;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMPONENT_IDENTIFICATION__COMPONENT, oldComponent, component));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getComponent() {
        return component;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setComponentIdType(String newComponentIdType) {
        String oldComponentIdType = componentIdType;
        componentIdType = newComponentIdType;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMPONENT_IDENTIFICATION__COMPONENT_ID_TYPE, oldComponentIdType, componentIdType));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getComponentIdType() {
        return componentIdType;
    }

    /**
     * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
     * @generated
     */
    public void setComponentType(String newComponentType) {
        String oldComponentType = componentType;
        componentType = newComponentType;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMPONENT_IDENTIFICATION__COMPONENT_TYPE, oldComponentType, componentType));
    }

    /**
     * <!-- begin-user-doc -->
         * <!-- end-user-doc -->
     * @generated
     */
    public String getComponentType() {
        return componentType;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setExecutionEnvironment(String newExecutionEnvironment) {
        String oldExecutionEnvironment = executionEnvironment;
        executionEnvironment = newExecutionEnvironment;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMPONENT_IDENTIFICATION__EXECUTION_ENVIRONMENT, oldExecutionEnvironment, executionEnvironment));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getExecutionEnvironment() {
        return executionEnvironment;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setInstanceId(String newInstanceId) {
        String oldInstanceId = instanceId;
        instanceId = newInstanceId;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMPONENT_IDENTIFICATION__INSTANCE_ID, oldInstanceId, instanceId));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getInstanceId() {
        return instanceId;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setLocation(String newLocation) {
        String oldLocation = location;
        location = newLocation;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMPONENT_IDENTIFICATION__LOCATION, oldLocation, location));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getLocation() {
        return location;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setLocationType(String newLocationType) {
        String oldLocationType = locationType;
        locationType = newLocationType;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMPONENT_IDENTIFICATION__LOCATION_TYPE, oldLocationType, locationType));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getLocationType() {
        return locationType;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setProcessId(String newProcessId) {
        String oldProcessId = processId;
        processId = newProcessId;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMPONENT_IDENTIFICATION__PROCESS_ID, oldProcessId, processId));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getProcessId() {
        return processId;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setSubComponent(String newSubComponent) {
        String oldSubComponent = subComponent;
        subComponent = newSubComponent;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMPONENT_IDENTIFICATION__SUB_COMPONENT, oldSubComponent, subComponent));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getSubComponent() {
        return subComponent;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setThreadId(String newThreadId) {
        String oldThreadId = threadId;
        threadId = newThreadId;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMPONENT_IDENTIFICATION__THREAD_ID, oldThreadId, threadId));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getThreadId() {
        return threadId;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.COMPONENT_IDENTIFICATION__APPLICATION :
                return getApplication();
            case EventPackage.COMPONENT_IDENTIFICATION__COMPONENT :
                return getComponent();
            case EventPackage.COMPONENT_IDENTIFICATION__COMPONENT_TYPE :
                return getComponentType();
            case EventPackage.COMPONENT_IDENTIFICATION__COMPONENT_ID_TYPE :
                return getComponentIdType();
            case EventPackage.COMPONENT_IDENTIFICATION__EXECUTION_ENVIRONMENT :
                return getExecutionEnvironment();
            case EventPackage.COMPONENT_IDENTIFICATION__INSTANCE_ID :
                return getInstanceId();
            case EventPackage.COMPONENT_IDENTIFICATION__LOCATION :
                return getLocation();
            case EventPackage.COMPONENT_IDENTIFICATION__LOCATION_TYPE :
                return getLocationType();
            case EventPackage.COMPONENT_IDENTIFICATION__PROCESS_ID :
                return getProcessId();
            case EventPackage.COMPONENT_IDENTIFICATION__SUB_COMPONENT :
                return getSubComponent();
            case EventPackage.COMPONENT_IDENTIFICATION__THREAD_ID :
                return getThreadId();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.COMPONENT_IDENTIFICATION__APPLICATION :
                return APPLICATION_EDEFAULT == null ? application != null : !APPLICATION_EDEFAULT.equals(application);
            case EventPackage.COMPONENT_IDENTIFICATION__COMPONENT :
                return COMPONENT_EDEFAULT == null ? component != null : !COMPONENT_EDEFAULT.equals(component);
            case EventPackage.COMPONENT_IDENTIFICATION__COMPONENT_TYPE :
                return COMPONENT_TYPE_EDEFAULT == null ? componentType != null : !COMPONENT_TYPE_EDEFAULT.equals(componentType);
            case EventPackage.COMPONENT_IDENTIFICATION__COMPONENT_ID_TYPE :
                return COMPONENT_ID_TYPE_EDEFAULT == null ? componentIdType != null : !COMPONENT_ID_TYPE_EDEFAULT.equals(componentIdType);
            case EventPackage.COMPONENT_IDENTIFICATION__EXECUTION_ENVIRONMENT :
                return EXECUTION_ENVIRONMENT_EDEFAULT == null ? executionEnvironment != null : !EXECUTION_ENVIRONMENT_EDEFAULT.equals(executionEnvironment);
            case EventPackage.COMPONENT_IDENTIFICATION__INSTANCE_ID :
                return INSTANCE_ID_EDEFAULT == null ? instanceId != null : !INSTANCE_ID_EDEFAULT.equals(instanceId);
            case EventPackage.COMPONENT_IDENTIFICATION__LOCATION :
                return LOCATION_EDEFAULT == null ? location != null : !LOCATION_EDEFAULT.equals(location);
            case EventPackage.COMPONENT_IDENTIFICATION__LOCATION_TYPE :
                return LOCATION_TYPE_EDEFAULT == null ? locationType != null : !LOCATION_TYPE_EDEFAULT.equals(locationType);
            case EventPackage.COMPONENT_IDENTIFICATION__PROCESS_ID :
                return PROCESS_ID_EDEFAULT == null ? processId != null : !PROCESS_ID_EDEFAULT.equals(processId);
            case EventPackage.COMPONENT_IDENTIFICATION__SUB_COMPONENT :
                return SUB_COMPONENT_EDEFAULT == null ? subComponent != null : !SUB_COMPONENT_EDEFAULT.equals(subComponent);
            case EventPackage.COMPONENT_IDENTIFICATION__THREAD_ID :
                return THREAD_ID_EDEFAULT == null ? threadId != null : !THREAD_ID_EDEFAULT.equals(threadId);
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.COMPONENT_IDENTIFICATION__APPLICATION :
                setApplication((String) newValue);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__COMPONENT :
                setComponent((String) newValue);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__COMPONENT_TYPE :
                setComponentType((String) newValue);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__COMPONENT_ID_TYPE :
                setComponentIdType((String) newValue);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__EXECUTION_ENVIRONMENT :
                setExecutionEnvironment((String) newValue);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__INSTANCE_ID :
                setInstanceId((String) newValue);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__LOCATION :
                setLocation((String) newValue);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__LOCATION_TYPE :
                setLocationType((String) newValue);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__PROCESS_ID :
                setProcessId((String) newValue);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__SUB_COMPONENT :
                setSubComponent((String) newValue);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__THREAD_ID :
                setThreadId((String) newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.COMPONENT_IDENTIFICATION__APPLICATION :
                setApplication(APPLICATION_EDEFAULT);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__COMPONENT :
                setComponent(COMPONENT_EDEFAULT);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__COMPONENT_TYPE :
                setComponentType(COMPONENT_TYPE_EDEFAULT);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__COMPONENT_ID_TYPE :
                setComponentIdType(COMPONENT_ID_TYPE_EDEFAULT);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__EXECUTION_ENVIRONMENT :
                setExecutionEnvironment(EXECUTION_ENVIRONMENT_EDEFAULT);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__INSTANCE_ID :
                setInstanceId(INSTANCE_ID_EDEFAULT);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__LOCATION :
                setLocation(LOCATION_EDEFAULT);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__LOCATION_TYPE :
                setLocationType(LOCATION_TYPE_EDEFAULT);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__PROCESS_ID :
                setProcessId(PROCESS_ID_EDEFAULT);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__SUB_COMPONENT :
                setSubComponent(SUB_COMPONENT_EDEFAULT);
                return;
            case EventPackage.COMPONENT_IDENTIFICATION__THREAD_ID :
                setThreadId(THREAD_ID_EDEFAULT);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     *
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object arg0) {

        synchronized(this){
            return EventHelpers.compareEObject(this, arg0);
        }
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy())
            return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (application: ");
        result.append(application);
        result.append(", component: ");
        result.append(component);
        result.append(", componentType: ");
        result.append(componentType);
        result.append(", componentIdType: ");
        result.append(componentIdType);
        result.append(", executionEnvironment: ");
        result.append(executionEnvironment);
        result.append(", instanceId: ");
        result.append(instanceId);
        result.append(", location: ");
        result.append(location);
        result.append(", locationType: ");
        result.append(locationType);
        result.append(", processId: ");
        result.append(processId);
        result.append(", subComponent: ");
        result.append(subComponent);
        result.append(", threadId: ");
        result.append(threadId);
        result.append(')');
        return result.toString();
    }

    /**
     * 
     * @see ComponentIdentification#validate()
     */
    public void validate() throws ValidationException {

        synchronized(this){

	        EAttribute attr;
	
	        // checking for required attributes
	        EventValidation.validateRequiredProperties(CLASS_NAME, this);
	
	        // checking for boundaries
	        attr = EventPackage.eINSTANCE.getComponentIdentification_Component();
	        EventValidation.validateLength(CLASS_NAME, this, attr, 256);
	
	        attr = EventPackage.eINSTANCE.getComponentIdentification_ComponentType();
	        EventValidation.validateLength(CLASS_NAME, this, attr, 512);
	
	        attr = EventPackage.eINSTANCE.getComponentIdentification_SubComponent();
	        EventValidation.validateLength(CLASS_NAME, this, attr, 512);
	
	        attr = EventPackage.eINSTANCE.getComponentIdentification_ComponentIdType();
	        EventValidation.validateLength(CLASS_NAME, this, attr, 32);
	
	        attr = EventPackage.eINSTANCE.getComponentIdentification_InstanceId();
	        EventValidation.validateLength(CLASS_NAME, this, attr, 128);
	
	        attr = EventPackage.eINSTANCE.getComponentIdentification_Application();
	        EventValidation.validateLength(CLASS_NAME, this, attr, 256);
	
	        attr = EventPackage.eINSTANCE.getComponentIdentification_ExecutionEnvironment();
	        EventValidation.validateLength(CLASS_NAME, this, attr, 256);
	
	        attr = EventPackage.eINSTANCE.getComponentIdentification_Location();
	        EventValidation.validateLength(CLASS_NAME, this, attr, 256);
	
	        attr = EventPackage.eINSTANCE.getComponentIdentification_LocationType();
	        EventValidation.validateLength(CLASS_NAME, this, attr, 32);
	
	        String locationTypeValue = getLocationType();
	
	        if (!LOCATION_TYPES_LIST.contains(locationTypeValue)) {
	            throw new ValidationException(EventHelpers.getString("LOG_COMPONENT_IDENTIFICATION_INVALID_LOCATION_TYPE_EXC_",getComponent(), getLocationType()));
	        }
	
	        attr = EventPackage.eINSTANCE.getComponentIdentification_ProcessId();
	        EventValidation.validateLength(CLASS_NAME, this, attr, 64);
	
	        attr = EventPackage.eINSTANCE.getComponentIdentification_ThreadId();
	        EventValidation.validateLength(CLASS_NAME, this, attr, 64);
        }
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getComponentIdentification();
    }

    /**
     * return a cloned (copy by value) object. This is a deep copy version, in which all the
     * objects within this object will be copied by value.
     *  
     * @return Object
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized(this){
            return EcoreUtil.copy(this);
        }       
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        setApplication(APPLICATION_EDEFAULT);
        setComponent(COMPONENT_EDEFAULT);
        setComponentIdType(COMPONENT_ID_TYPE_EDEFAULT);
        setComponentType(COMPONENT_TYPE_EDEFAULT);
        setExecutionEnvironment(EXECUTION_ENVIRONMENT_EDEFAULT);
        setInstanceId(INSTANCE_ID_EDEFAULT);
        setLocation(LOCATION_EDEFAULT);
        setLocationType(LOCATION_TYPE_EDEFAULT);
        setProcessId(PROCESS_ID_EDEFAULT);
        setSubComponent(SUB_COMPONENT_EDEFAULT);
        setThreadId(THREAD_ID_EDEFAULT);
    }
} //ComponentIdentificationImpl
