package org.eclipse.hyades.logging.events.cbe.impl;

import java.io.Serializable;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EventPackageImpl.java,v 1.7 2005/02/16 22:20:40 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class EventPackageImpl extends EPackageImpl implements EventPackage {

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass associatedEventEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass associationEngineEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass availableSituationEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass commonBaseEventEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass componentIdentificationEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass configureSituationEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass connectSituationEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass contextDataElementEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass createSituationEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass dependencySituationEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass destroySituationEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass extendedDataElementEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass featureSituationEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass msgCatalogTokenEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass msgDataElementEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass otherSituationEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass reportSituationEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass requestSituationEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass situationEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass situationTypeEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass startSituationEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass stopSituationEClass = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private EClass serializableEClass = null;

    /**
     * Creates an instance of the model <b>Package</b>, registered with
     * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
     * package URI value.
     * <p>Note: the correct way to create the package is via the static
     * factory method {@link #init init()}, which also performs
     * initialization of the package, or returns the registered package,
     * if one already exists.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.eclipse.emf.ecore.EPackage.Registry
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#eNS_URI
     * @see #init()
     * @generated
     */
    private EventPackageImpl() {
        super(eNS_URI, EventFactory.eINSTANCE);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private static boolean isInited = false;

    /**
     * Creates, registers, and initializes the <b>Package</b> for this
     * model, and for any others upon which it depends.  Simple
     * dependencies are satisfied by calling this method on all
     * dependent packages before doing anything else.  This method drives
     * initialization for interdependent packages directly, in parallel
     * with this package, itself.
     * <p>Of this package and its interdependencies, all packages which
     * have not yet been registered by their URI values are first created
     * and registered.  The packages are then initialized in two steps:
     * meta-model objects for all of the packages are created before any
     * are initialized, since one package's meta-model objects may refer to
     * those of another.
     * <p>Invocation of this method will not affect any packages that have
     * already been initialized.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #eNS_URI
     * @see #createPackageContents()
     * @see #initializePackageContents()
     * @generated
     */
    public static EventPackage init() {
        if (isInited)
            return (EventPackage) EPackage.Registry.INSTANCE.get(EventPackage.eNS_URI);

        // Obtain or create and register package.
        EventPackageImpl theEventPackage = (EventPackageImpl) (EPackage.Registry.INSTANCE.get(eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(eNS_URI) : new EventPackageImpl());

        isInited = true;

        // Obtain or create and register interdependencies

        // Step 1: create meta-model objects
        theEventPackage.createPackageContents();

        // Step 2: complete initialization
        theEventPackage.initializePackageContents();

        return theEventPackage;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getAssociatedEvent() {
        return associatedEventEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getAssociatedEvent_AssociationEngine() {
        return (EAttribute) associatedEventEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getAssociatedEvent_ResolvedEvents() {
        return (EAttribute) associatedEventEClass.getEAttributes().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getAssociatedEvent_AssociationEngineInfo() {
        return (EReference) associatedEventEClass.getEReferences().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getAssociationEngine() {
        return associationEngineEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getAssociationEngine_Id() {
        return (EAttribute) associationEngineEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getAssociationEngine_Name() {
        return (EAttribute) associationEngineEClass.getEAttributes().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getAssociationEngine_Type() {
        return (EAttribute) associationEngineEClass.getEAttributes().get(2);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getAvailableSituation() {
        return availableSituationEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getAvailableSituation_OperationDisposition() {
        return (EAttribute) availableSituationEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getAvailableSituation_AvailabilityDisposition() {
        return (EAttribute) availableSituationEClass.getEAttributes().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getAvailableSituation_ProcessingDisposition() {
        return (EAttribute) availableSituationEClass.getEAttributes().get(2);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getCommonBaseEvent() {
        return commonBaseEventEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getCommonBaseEvent_CreationTime() {
        return (EAttribute) commonBaseEventEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getCommonBaseEvent_GlobalInstanceId() {
        return (EAttribute) commonBaseEventEClass.getEAttributes().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getCommonBaseEvent_ElapsedTime() {
        return (EAttribute) commonBaseEventEClass.getEAttributes().get(2);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getCommonBaseEvent_ExtensionName() {
        return (EAttribute) commonBaseEventEClass.getEAttributes().get(3);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getCommonBaseEvent_LocalInstanceId() {
        return (EAttribute) commonBaseEventEClass.getEAttributes().get(4);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getCommonBaseEvent_Msg() {
        return (EAttribute) commonBaseEventEClass.getEAttributes().get(5);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getCommonBaseEvent_Priority() {
        return (EAttribute) commonBaseEventEClass.getEAttributes().get(6);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getCommonBaseEvent_RepeatCount() {
        return (EAttribute) commonBaseEventEClass.getEAttributes().get(7);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getCommonBaseEvent_SequenceNumber() {
        return (EAttribute) commonBaseEventEClass.getEAttributes().get(8);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getCommonBaseEvent_Severity() {
        return (EAttribute) commonBaseEventEClass.getEAttributes().get(9);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getCommonBaseEvent_Version() {
        return (EAttribute) commonBaseEventEClass.getEAttributes().get(10);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getCommonBaseEvent_Situation() {
        return (EReference) commonBaseEventEClass.getEReferences().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getCommonBaseEvent_Any() {
        return (EAttribute) commonBaseEventEClass.getEAttributes().get(11);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getCommonBaseEvent_AssociatedEvents() {
        return (EReference) commonBaseEventEClass.getEReferences().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getCommonBaseEvent_ContextDataElements() {
        return (EReference) commonBaseEventEClass.getEReferences().get(2);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getCommonBaseEvent_ExtendedDataElements() {
        return (EReference) commonBaseEventEClass.getEReferences().get(3);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getCommonBaseEvent_MsgDataElement() {
        return (EReference) commonBaseEventEClass.getEReferences().get(4);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getCommonBaseEvent_ReporterComponentId() {
        return (EReference) commonBaseEventEClass.getEReferences().get(5);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getCommonBaseEvent_SourceComponentId() {
        return (EReference) commonBaseEventEClass.getEReferences().get(6);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getComponentIdentification() {
        return componentIdentificationEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getComponentIdentification_Application() {
        return (EAttribute) componentIdentificationEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getComponentIdentification_Component() {
        return (EAttribute) componentIdentificationEClass.getEAttributes().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getComponentIdentification_ComponentType() {
        return (EAttribute) componentIdentificationEClass.getEAttributes().get(2);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getComponentIdentification_ComponentIdType() {
        return (EAttribute) componentIdentificationEClass.getEAttributes().get(3);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getComponentIdentification_ExecutionEnvironment() {
        return (EAttribute) componentIdentificationEClass.getEAttributes().get(4);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getComponentIdentification_InstanceId() {
        return (EAttribute) componentIdentificationEClass.getEAttributes().get(5);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getComponentIdentification_Location() {
        return (EAttribute) componentIdentificationEClass.getEAttributes().get(6);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getComponentIdentification_LocationType() {
        return (EAttribute) componentIdentificationEClass.getEAttributes().get(7);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getComponentIdentification_ProcessId() {
        return (EAttribute) componentIdentificationEClass.getEAttributes().get(8);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getComponentIdentification_SubComponent() {
        return (EAttribute) componentIdentificationEClass.getEAttributes().get(9);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getComponentIdentification_ThreadId() {
        return (EAttribute) componentIdentificationEClass.getEAttributes().get(10);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getConfigureSituation() {
        return configureSituationEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getConfigureSituation_SuccessDisposition() {
        return (EAttribute) configureSituationEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getConnectSituation() {
        return connectSituationEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getConnectSituation_SuccessDisposition() {
        return (EAttribute) connectSituationEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getConnectSituation_SituationDisposition() {
        return (EAttribute) connectSituationEClass.getEAttributes().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getContextDataElement() {
        return contextDataElementEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getContextDataElement_ContextId() {
        return (EAttribute) contextDataElementEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getContextDataElement_ContextValue() {
        return (EAttribute) contextDataElementEClass.getEAttributes().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getContextDataElement_Name() {
        return (EAttribute) contextDataElementEClass.getEAttributes().get(2);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getContextDataElement_Type() {
        return (EAttribute) contextDataElementEClass.getEAttributes().get(3);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getCreateSituation() {
        return createSituationEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getCreateSituation_SuccessDisposition() {
        return (EAttribute) createSituationEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getDependencySituation() {
        return dependencySituationEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getDependencySituation_DependencyDisposition() {
        return (EAttribute) dependencySituationEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getDestroySituation() {
        return destroySituationEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getDestroySituation_SuccessDisposition() {
        return (EAttribute) destroySituationEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getExtendedDataElement() {
        return extendedDataElementEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getExtendedDataElement_HexValue() {
        return (EAttribute) extendedDataElementEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getExtendedDataElement_Name() {
        return (EAttribute) extendedDataElementEClass.getEAttributes().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getExtendedDataElement_Type() {
        return (EAttribute) extendedDataElementEClass.getEAttributes().get(2);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getExtendedDataElement_Values() {
        return (EAttribute) extendedDataElementEClass.getEAttributes().get(3);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getExtendedDataElement_Children() {
        return (EReference) extendedDataElementEClass.getEReferences().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getFeatureSituation() {
        return featureSituationEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getFeatureSituation_FeatureDisposition() {
        return (EAttribute) featureSituationEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getMsgCatalogToken() {
        return msgCatalogTokenEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getMsgCatalogToken_Value() {
        return (EAttribute) msgCatalogTokenEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getMsgDataElement() {
        return msgDataElementEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getMsgDataElement_MsgIdType() {
        return (EAttribute) msgDataElementEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getMsgDataElement_MsgCatalogType() {
        return (EAttribute) msgDataElementEClass.getEAttributes().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getMsgDataElement_MsgCatalog() {
        return (EAttribute) msgDataElementEClass.getEAttributes().get(2);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getMsgDataElement_MsgCatalogId() {
        return (EAttribute) msgDataElementEClass.getEAttributes().get(3);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getMsgDataElement_MsgId() {
        return (EAttribute) msgDataElementEClass.getEAttributes().get(4);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getMsgDataElement_MsgLocale() {
        return (EAttribute) msgDataElementEClass.getEAttributes().get(5);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getMsgDataElement_MsgCatalogTokens() {
        return (EReference) msgDataElementEClass.getEReferences().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getOtherSituation() {
        return otherSituationEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getOtherSituation_Any() {
        return (EAttribute) otherSituationEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getReportSituation() {
        return reportSituationEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getReportSituation_ReportCategory() {
        return (EAttribute) reportSituationEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getRequestSituation() {
        return requestSituationEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getRequestSituation_SuccessDisposition() {
        return (EAttribute) requestSituationEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getRequestSituation_SituationQualifier() {
        return (EAttribute) requestSituationEClass.getEAttributes().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getSituation() {
        return situationEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getSituation_CategoryName() {
        return (EAttribute) situationEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EReference getSituation_SituationType() {
        return (EReference) situationEClass.getEReferences().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getSituationType() {
        return situationTypeEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getSituationType_ReasoningScope() {
        return (EAttribute) situationTypeEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getStartSituation() {
        return startSituationEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getStartSituation_SuccessDisposition() {
        return (EAttribute) startSituationEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getStartSituation_SituationQualifier() {
        return (EAttribute) startSituationEClass.getEAttributes().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getStopSituation() {
        return stopSituationEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getStopSituation_SuccessDisposition() {
        return (EAttribute) stopSituationEClass.getEAttributes().get(0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EAttribute getStopSituation_SituationQualifier() {
        return (EAttribute) stopSituationEClass.getEAttributes().get(1);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EClass getSerializable() {
        return serializableEClass;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EventFactory getEventFactory() {
        return (EventFactory) getEFactoryInstance();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private boolean isCreated = false;

    /**
     * Creates the meta-model objects for the package.  This method is
     * guarded to have no affect on any invocation but its first.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void createPackageContents() {
        if (isCreated)
            return;
        isCreated = true;

        // Create classes and their features
        associatedEventEClass = createEClass(ASSOCIATED_EVENT);
        createEAttribute(associatedEventEClass, ASSOCIATED_EVENT__ASSOCIATION_ENGINE);
        createEAttribute(associatedEventEClass, ASSOCIATED_EVENT__RESOLVED_EVENTS);
        createEReference(associatedEventEClass, ASSOCIATED_EVENT__ASSOCIATION_ENGINE_INFO);

        associationEngineEClass = createEClass(ASSOCIATION_ENGINE);
        createEAttribute(associationEngineEClass, ASSOCIATION_ENGINE__ID);
        createEAttribute(associationEngineEClass, ASSOCIATION_ENGINE__NAME);
        createEAttribute(associationEngineEClass, ASSOCIATION_ENGINE__TYPE);

        availableSituationEClass = createEClass(AVAILABLE_SITUATION);
        createEAttribute(availableSituationEClass, AVAILABLE_SITUATION__OPERATION_DISPOSITION);
        createEAttribute(availableSituationEClass, AVAILABLE_SITUATION__AVAILABILITY_DISPOSITION);
        createEAttribute(availableSituationEClass, AVAILABLE_SITUATION__PROCESSING_DISPOSITION);

        commonBaseEventEClass = createEClass(COMMON_BASE_EVENT);
        createEAttribute(commonBaseEventEClass, COMMON_BASE_EVENT__CREATION_TIME);
        createEAttribute(commonBaseEventEClass, COMMON_BASE_EVENT__GLOBAL_INSTANCE_ID);
        createEAttribute(commonBaseEventEClass, COMMON_BASE_EVENT__ELAPSED_TIME);
        createEAttribute(commonBaseEventEClass, COMMON_BASE_EVENT__EXTENSION_NAME);
        createEAttribute(commonBaseEventEClass, COMMON_BASE_EVENT__LOCAL_INSTANCE_ID);
        createEAttribute(commonBaseEventEClass, COMMON_BASE_EVENT__MSG);
        createEAttribute(commonBaseEventEClass, COMMON_BASE_EVENT__PRIORITY);
        createEAttribute(commonBaseEventEClass, COMMON_BASE_EVENT__REPEAT_COUNT);
        createEAttribute(commonBaseEventEClass, COMMON_BASE_EVENT__SEQUENCE_NUMBER);
        createEAttribute(commonBaseEventEClass, COMMON_BASE_EVENT__SEVERITY);
        createEAttribute(commonBaseEventEClass, COMMON_BASE_EVENT__VERSION);
        createEAttribute(commonBaseEventEClass, COMMON_BASE_EVENT__ANY);
        createEReference(commonBaseEventEClass, COMMON_BASE_EVENT__SITUATION);
        createEReference(commonBaseEventEClass, COMMON_BASE_EVENT__ASSOCIATED_EVENTS);
        createEReference(commonBaseEventEClass, COMMON_BASE_EVENT__CONTEXT_DATA_ELEMENTS);
        createEReference(commonBaseEventEClass, COMMON_BASE_EVENT__EXTENDED_DATA_ELEMENTS);
        createEReference(commonBaseEventEClass, COMMON_BASE_EVENT__MSG_DATA_ELEMENT);
        createEReference(commonBaseEventEClass, COMMON_BASE_EVENT__REPORTER_COMPONENT_ID);
        createEReference(commonBaseEventEClass, COMMON_BASE_EVENT__SOURCE_COMPONENT_ID);

        componentIdentificationEClass = createEClass(COMPONENT_IDENTIFICATION);
        createEAttribute(componentIdentificationEClass, COMPONENT_IDENTIFICATION__APPLICATION);
        createEAttribute(componentIdentificationEClass, COMPONENT_IDENTIFICATION__COMPONENT);
        createEAttribute(componentIdentificationEClass, COMPONENT_IDENTIFICATION__COMPONENT_TYPE);
        createEAttribute(componentIdentificationEClass, COMPONENT_IDENTIFICATION__COMPONENT_ID_TYPE);
        createEAttribute(componentIdentificationEClass, COMPONENT_IDENTIFICATION__EXECUTION_ENVIRONMENT);
        createEAttribute(componentIdentificationEClass, COMPONENT_IDENTIFICATION__INSTANCE_ID);
        createEAttribute(componentIdentificationEClass, COMPONENT_IDENTIFICATION__LOCATION);
        createEAttribute(componentIdentificationEClass, COMPONENT_IDENTIFICATION__LOCATION_TYPE);
        createEAttribute(componentIdentificationEClass, COMPONENT_IDENTIFICATION__PROCESS_ID);
        createEAttribute(componentIdentificationEClass, COMPONENT_IDENTIFICATION__SUB_COMPONENT);
        createEAttribute(componentIdentificationEClass, COMPONENT_IDENTIFICATION__THREAD_ID);

        configureSituationEClass = createEClass(CONFIGURE_SITUATION);
        createEAttribute(configureSituationEClass, CONFIGURE_SITUATION__SUCCESS_DISPOSITION);

        connectSituationEClass = createEClass(CONNECT_SITUATION);
        createEAttribute(connectSituationEClass, CONNECT_SITUATION__SUCCESS_DISPOSITION);
        createEAttribute(connectSituationEClass, CONNECT_SITUATION__SITUATION_DISPOSITION);

        contextDataElementEClass = createEClass(CONTEXT_DATA_ELEMENT);
        createEAttribute(contextDataElementEClass, CONTEXT_DATA_ELEMENT__CONTEXT_ID);
        createEAttribute(contextDataElementEClass, CONTEXT_DATA_ELEMENT__CONTEXT_VALUE);
        createEAttribute(contextDataElementEClass, CONTEXT_DATA_ELEMENT__NAME);
        createEAttribute(contextDataElementEClass, CONTEXT_DATA_ELEMENT__TYPE);

        createSituationEClass = createEClass(CREATE_SITUATION);
        createEAttribute(createSituationEClass, CREATE_SITUATION__SUCCESS_DISPOSITION);

        dependencySituationEClass = createEClass(DEPENDENCY_SITUATION);
        createEAttribute(dependencySituationEClass, DEPENDENCY_SITUATION__DEPENDENCY_DISPOSITION);

        destroySituationEClass = createEClass(DESTROY_SITUATION);
        createEAttribute(destroySituationEClass, DESTROY_SITUATION__SUCCESS_DISPOSITION);

        extendedDataElementEClass = createEClass(EXTENDED_DATA_ELEMENT);
        createEAttribute(extendedDataElementEClass, EXTENDED_DATA_ELEMENT__HEX_VALUE);
        createEAttribute(extendedDataElementEClass, EXTENDED_DATA_ELEMENT__NAME);
        createEAttribute(extendedDataElementEClass, EXTENDED_DATA_ELEMENT__TYPE);
        createEAttribute(extendedDataElementEClass, EXTENDED_DATA_ELEMENT__VALUES);
        createEReference(extendedDataElementEClass, EXTENDED_DATA_ELEMENT__CHILDREN);

        featureSituationEClass = createEClass(FEATURE_SITUATION);
        createEAttribute(featureSituationEClass, FEATURE_SITUATION__FEATURE_DISPOSITION);

        msgCatalogTokenEClass = createEClass(MSG_CATALOG_TOKEN);
        createEAttribute(msgCatalogTokenEClass, MSG_CATALOG_TOKEN__VALUE);

        msgDataElementEClass = createEClass(MSG_DATA_ELEMENT);
        createEAttribute(msgDataElementEClass, MSG_DATA_ELEMENT__MSG_ID_TYPE);
        createEAttribute(msgDataElementEClass, MSG_DATA_ELEMENT__MSG_CATALOG_TYPE);
        createEAttribute(msgDataElementEClass, MSG_DATA_ELEMENT__MSG_CATALOG);
        createEAttribute(msgDataElementEClass, MSG_DATA_ELEMENT__MSG_CATALOG_ID);
        createEAttribute(msgDataElementEClass, MSG_DATA_ELEMENT__MSG_ID);
        createEAttribute(msgDataElementEClass, MSG_DATA_ELEMENT__MSG_LOCALE);
        createEReference(msgDataElementEClass, MSG_DATA_ELEMENT__MSG_CATALOG_TOKENS);

        otherSituationEClass = createEClass(OTHER_SITUATION);
        createEAttribute(otherSituationEClass, OTHER_SITUATION__ANY);

        reportSituationEClass = createEClass(REPORT_SITUATION);
        createEAttribute(reportSituationEClass, REPORT_SITUATION__REPORT_CATEGORY);

        requestSituationEClass = createEClass(REQUEST_SITUATION);
        createEAttribute(requestSituationEClass, REQUEST_SITUATION__SUCCESS_DISPOSITION);
        createEAttribute(requestSituationEClass, REQUEST_SITUATION__SITUATION_QUALIFIER);

        situationEClass = createEClass(SITUATION);
        createEAttribute(situationEClass, SITUATION__CATEGORY_NAME);
        createEReference(situationEClass, SITUATION__SITUATION_TYPE);

        situationTypeEClass = createEClass(SITUATION_TYPE);
        createEAttribute(situationTypeEClass, SITUATION_TYPE__REASONING_SCOPE);

        startSituationEClass = createEClass(START_SITUATION);
        createEAttribute(startSituationEClass, START_SITUATION__SUCCESS_DISPOSITION);
        createEAttribute(startSituationEClass, START_SITUATION__SITUATION_QUALIFIER);

        stopSituationEClass = createEClass(STOP_SITUATION);
        createEAttribute(stopSituationEClass, STOP_SITUATION__SUCCESS_DISPOSITION);
        createEAttribute(stopSituationEClass, STOP_SITUATION__SITUATION_QUALIFIER);

        serializableEClass = createEClass(SERIALIZABLE);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    private boolean isInitialized = false;

    /**
     * Complete the initialization of the package and its meta-model.  This
     * method is guarded to have no affect on any invocation but its first.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void initializePackageContents() {
        if (isInitialized)
            return;
        isInitialized = true;

        // Initialize package
        setName(eNAME);
        setNsPrefix(eNS_PREFIX);
        setNsURI(eNS_URI);

        // Add supertypes to classes
        associatedEventEClass.getESuperTypes().add(this.getSerializable());
        associationEngineEClass.getESuperTypes().add(this.getSerializable());
        availableSituationEClass.getESuperTypes().add(this.getSituationType());
        commonBaseEventEClass.getESuperTypes().add(this.getSerializable());
        componentIdentificationEClass.getESuperTypes().add(this.getSerializable());
        configureSituationEClass.getESuperTypes().add(this.getSituationType());
        connectSituationEClass.getESuperTypes().add(this.getSituationType());
        contextDataElementEClass.getESuperTypes().add(this.getSerializable());
        createSituationEClass.getESuperTypes().add(this.getSituationType());
        dependencySituationEClass.getESuperTypes().add(this.getSituationType());
        destroySituationEClass.getESuperTypes().add(this.getSituationType());
        extendedDataElementEClass.getESuperTypes().add(this.getSerializable());
        featureSituationEClass.getESuperTypes().add(this.getSituationType());
        msgCatalogTokenEClass.getESuperTypes().add(this.getSerializable());
        msgDataElementEClass.getESuperTypes().add(this.getSerializable());
        otherSituationEClass.getESuperTypes().add(this.getSituationType());
        reportSituationEClass.getESuperTypes().add(this.getSituationType());
        requestSituationEClass.getESuperTypes().add(this.getSituationType());
        situationEClass.getESuperTypes().add(this.getSerializable());
        situationTypeEClass.getESuperTypes().add(this.getSerializable());
        startSituationEClass.getESuperTypes().add(this.getSituationType());
        stopSituationEClass.getESuperTypes().add(this.getSituationType());

        // Initialize classes and features; add operations and parameters
        initEClass(associatedEventEClass, AssociatedEvent.class, "AssociatedEvent", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getAssociatedEvent_AssociationEngine(), ecorePackage.getEString(), "associationEngine", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getAssociatedEvent_ResolvedEvents(), ecorePackage.getEString(), "resolvedEvents", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEReference(getAssociatedEvent_AssociationEngineInfo(), this.getAssociationEngine(), null, "associationEngineInfo", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

        initEClass(associationEngineEClass, AssociationEngine.class, "AssociationEngine", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getAssociationEngine_Id(), ecorePackage.getEString(), "id", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, IS_UNIQUE);
        initEAttribute(getAssociationEngine_Name(), ecorePackage.getEString(), "name", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getAssociationEngine_Type(), ecorePackage.getEString(), "type", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

        initEClass(availableSituationEClass, AvailableSituation.class, "AvailableSituation", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getAvailableSituation_OperationDisposition(), ecorePackage.getEString(), "operationDisposition", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getAvailableSituation_AvailabilityDisposition(), ecorePackage.getEString(), "availabilityDisposition", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getAvailableSituation_ProcessingDisposition(), ecorePackage.getEString(), "processingDisposition", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

        initEClass(commonBaseEventEClass, CommonBaseEvent.class, "CommonBaseEvent", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getCommonBaseEvent_CreationTime(), ecorePackage.getEString(), "creationTime", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE);
        initEAttribute(getCommonBaseEvent_GlobalInstanceId(), ecorePackage.getEString(), "globalInstanceId", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getCommonBaseEvent_ElapsedTime(), ecorePackage.getELong(), "elapsedTime", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE);
        initEAttribute(getCommonBaseEvent_ExtensionName(), ecorePackage.getEString(), "extensionName", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getCommonBaseEvent_LocalInstanceId(), ecorePackage.getEString(), "localInstanceId", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getCommonBaseEvent_Msg(), ecorePackage.getEString(), "msg", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getCommonBaseEvent_Priority(), ecorePackage.getEShort(), "priority", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getCommonBaseEvent_RepeatCount(), ecorePackage.getEShort(), "repeatCount", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getCommonBaseEvent_SequenceNumber(), ecorePackage.getELong(), "sequenceNumber", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getCommonBaseEvent_Severity(), ecorePackage.getEShort(), "severity", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getCommonBaseEvent_Version(), ecorePackage.getEString(), "version", "1.0.1", 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getCommonBaseEvent_Any(), ecorePackage.getEString(), "any", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE);
        initEReference(getCommonBaseEvent_Situation(), this.getSituation(), null, "situation", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
        initEReference(getCommonBaseEvent_AssociatedEvents(), this.getAssociatedEvent(), null, "associatedEvents", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
        initEReference(getCommonBaseEvent_ContextDataElements(), this.getContextDataElement(), null, "contextDataElements", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
        initEReference(getCommonBaseEvent_ExtendedDataElements(), this.getExtendedDataElement(), null, "extendedDataElements", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
        initEReference(getCommonBaseEvent_MsgDataElement(), this.getMsgDataElement(), null, "msgDataElement", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
        initEReference(getCommonBaseEvent_ReporterComponentId(), this.getComponentIdentification(), null, "reporterComponentId", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
        initEReference(getCommonBaseEvent_SourceComponentId(), this.getComponentIdentification(), null, "sourceComponentId", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

        initEClass(componentIdentificationEClass, ComponentIdentification.class, "ComponentIdentification", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getComponentIdentification_Application(), ecorePackage.getEString(), "application", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getComponentIdentification_Component(), ecorePackage.getEString(), "component", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getComponentIdentification_ComponentType(), ecorePackage.getEString(), "componentType", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getComponentIdentification_ComponentIdType(), ecorePackage.getEString(), "componentIdType", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getComponentIdentification_ExecutionEnvironment(), ecorePackage.getEString(), "executionEnvironment", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getComponentIdentification_InstanceId(), ecorePackage.getEString(), "instanceId", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getComponentIdentification_Location(), ecorePackage.getEString(), "location", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getComponentIdentification_LocationType(), ecorePackage.getEString(), "locationType", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getComponentIdentification_ProcessId(), ecorePackage.getEString(), "processId", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getComponentIdentification_SubComponent(), ecorePackage.getEString(), "subComponent", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getComponentIdentification_ThreadId(), ecorePackage.getEString(), "threadId", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

        initEClass(configureSituationEClass, ConfigureSituation.class, "ConfigureSituation", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getConfigureSituation_SuccessDisposition(), ecorePackage.getEString(), "successDisposition", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

        initEClass(connectSituationEClass, ConnectSituation.class, "ConnectSituation", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getConnectSituation_SuccessDisposition(), ecorePackage.getEString(), "successDisposition", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getConnectSituation_SituationDisposition(), ecorePackage.getEString(), "situationDisposition", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

        initEClass(contextDataElementEClass, ContextDataElement.class, "ContextDataElement", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getContextDataElement_ContextId(), ecorePackage.getEString(), "contextId", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getContextDataElement_ContextValue(), ecorePackage.getEString(), "contextValue", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getContextDataElement_Name(), ecorePackage.getEString(), "name", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getContextDataElement_Type(), ecorePackage.getEString(), "type", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

        initEClass(createSituationEClass, CreateSituation.class, "CreateSituation", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getCreateSituation_SuccessDisposition(), ecorePackage.getEString(), "successDisposition", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

        initEClass(dependencySituationEClass, DependencySituation.class, "DependencySituation", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getDependencySituation_DependencyDisposition(), ecorePackage.getEString(), "dependencyDisposition", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

        initEClass(destroySituationEClass, DestroySituation.class, "DestroySituation", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getDestroySituation_SuccessDisposition(), ecorePackage.getEString(), "successDisposition", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

        initEClass(extendedDataElementEClass, ExtendedDataElement.class, "ExtendedDataElement", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getExtendedDataElement_HexValue(), ecorePackage.getEString(), "hexValue", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getExtendedDataElement_Name(), ecorePackage.getEString(), "name", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getExtendedDataElement_Type(), ecorePackage.getEString(), "type", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getExtendedDataElement_Values(), ecorePackage.getEString(), "values", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE);
        initEReference(getExtendedDataElement_Children(), this.getExtendedDataElement(), null, "children", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

        initEClass(featureSituationEClass, FeatureSituation.class, "FeatureSituation", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getFeatureSituation_FeatureDisposition(), ecorePackage.getEString(), "featureDisposition", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

        initEClass(msgCatalogTokenEClass, MsgCatalogToken.class, "MsgCatalogToken", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getMsgCatalogToken_Value(), ecorePackage.getEString(), "value", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

        initEClass(msgDataElementEClass, MsgDataElement.class, "MsgDataElement", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getMsgDataElement_MsgIdType(), ecorePackage.getEString(), "msgIdType", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getMsgDataElement_MsgCatalogType(), ecorePackage.getEString(), "msgCatalogType", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getMsgDataElement_MsgCatalog(), ecorePackage.getEString(), "msgCatalog", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getMsgDataElement_MsgCatalogId(), ecorePackage.getEString(), "msgCatalogId", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getMsgDataElement_MsgId(), ecorePackage.getEString(), "msgId", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getMsgDataElement_MsgLocale(), ecorePackage.getEString(), "msgLocale", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEReference(getMsgDataElement_MsgCatalogTokens(), this.getMsgCatalogToken(), null, "msgCatalogTokens", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

        initEClass(otherSituationEClass, OtherSituation.class, "OtherSituation", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getOtherSituation_Any(), ecorePackage.getEString(), "any", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

        initEClass(reportSituationEClass, ReportSituation.class, "ReportSituation", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getReportSituation_ReportCategory(), ecorePackage.getEString(), "reportCategory", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

        initEClass(requestSituationEClass, RequestSituation.class, "RequestSituation", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getRequestSituation_SuccessDisposition(), ecorePackage.getEString(), "successDisposition", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getRequestSituation_SituationQualifier(), ecorePackage.getEString(), "situationQualifier", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

        initEClass(situationEClass, Situation.class, "Situation", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getSituation_CategoryName(), ecorePackage.getEString(), "categoryName", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEReference(getSituation_SituationType(), this.getSituationType(), null, "situationType", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

        initEClass(situationTypeEClass, SituationType.class, "SituationType", IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getSituationType_ReasoningScope(), ecorePackage.getEString(), "reasoningScope", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

        initEClass(startSituationEClass, StartSituation.class, "StartSituation", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getStartSituation_SuccessDisposition(), ecorePackage.getEString(), "successDisposition", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getStartSituation_SituationQualifier(), ecorePackage.getEString(), "situationQualifier", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

        initEClass(stopSituationEClass, StopSituation.class, "StopSituation", !IS_ABSTRACT, !IS_INTERFACE);
        initEAttribute(getStopSituation_SuccessDisposition(), ecorePackage.getEString(), "successDisposition", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
        initEAttribute(getStopSituation_SituationQualifier(), ecorePackage.getEString(), "situationQualifier", null, 1, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);

        initEClass(serializableEClass, Serializable.class, "Serializable", IS_ABSTRACT, !IS_INTERFACE);

        // Create resource
        createResource(eNS_URI);
    }
} //EventPackageImpl
