package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;
import org.eclipse.hyades.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SituationImplTest.java,v 1.4 2005/02/16 22:20:40 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * JUnit testcase for <code>SituationImpl</code>.
 * 
 * @author Andrea Chiavegatto
 * @author Scott Brown
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 */
public class SituationImplTest extends TestCase {
    /* Target instance for all tests. */
    Situation sit = null;

    /**
     * Constructor for SituationImplTest.
     * @param arg0
     */
    public SituationImplTest(String arg0) {
        super(arg0);
    }

    /**
     *
     */
    public void testSetAvailableSituation() {
        String reasoning = "r";
        String av = "availability";
        String op = "operation";
        String pr = "processing";
        sit.setAvailableSituation(reasoning, av, op, pr);

        // test categoryName
        assertTrue(sit.getCategoryName().equals(Situation.AVAILABLE_SITUATION_CATEGORY));

        // test situation object contents
        AvailableSituation as = (AvailableSituation) sit.getSituationType();
        assertTrue(as.getReasoningScope().equals(reasoning));
        assertTrue(as.getAvailabilityDisposition().equals(av));
        assertTrue(as.getOperationDisposition().equals(op));
        assertTrue(as.getProcessingDisposition().equals(pr));
    }

    /**
     *
     */
    public void testSetCategoryName() {
        sit.setCategoryName(Situation.CREATE_SITUATION_CATEGORY);
        assertTrue(sit.getCategoryName().equals(Situation.CREATE_SITUATION_CATEGORY));

        sit.setCategoryName(Situation.DESTROY_SITUATION_CATEGORY);
        assertTrue(sit.getCategoryName().equals(Situation.DESTROY_SITUATION_CATEGORY));

    }

    /**
     *
     */
    public void testGetCategoryName() {
        assertTrue(sit.getCategoryName() == null);

        sit.setCategoryName(Situation.CONNECT_SITUATION_CATEGORY);

        assertTrue(sit.getCategoryName().equals(Situation.CONNECT_SITUATION_CATEGORY));
    }

    /**
     *
     */
    public void testSetConfigureSituation() {
        String reasoning = "r";
        String su = "success";
        sit.setConfigureSituation(reasoning, su);

        // test categoryName
        assertTrue(sit.getCategoryName().equals(Situation.CONFIGURE_SITUATION_CATEGORY));

        // test situation object contents
        ConfigureSituation cs = (ConfigureSituation) sit.getSituationType();
        assertTrue(cs.getReasoningScope().equals(reasoning));
        assertTrue(cs.getSuccessDisposition().equals(su));
    }

    /**
     *
     */
    public void testSetConnectSituation() {
        String reasoning = "r";
        String si = "situation";
        String su = "success";
        sit.setConnectSituation(reasoning, si, su);

        // test categoryName
        assertTrue(sit.getCategoryName().equals(Situation.CONNECT_SITUATION_CATEGORY));

        // test situation object contents
        ConnectSituation cs = (ConnectSituation) sit.getSituationType();
        assertTrue(cs.getReasoningScope().equals(reasoning));
        assertTrue(cs.getSituationDisposition().equals(si));
        assertTrue(cs.getSuccessDisposition().equals(su));
    }

    /**
     *
     */
    public void testSetCreateSituation() {
        String reasoning = "r";
        String su = "success";
        sit.setCreateSituation(reasoning, su);

        // test categoryName
        assertTrue(sit.getCategoryName().equals(Situation.CREATE_SITUATION_CATEGORY));

        // test situation object contents
        CreateSituation cs = (CreateSituation) sit.getSituationType();
        assertTrue(cs.getReasoningScope().equals(reasoning));
        assertTrue(cs.getSuccessDisposition().equals(su));
    }

    /**
     *
     */
    public void testSetDependencySituation() {
        String reasoning = "r";
        String de = "dependency";
        sit.setDependencySituation(reasoning, de);

        // test categoryName
        assertTrue(sit.getCategoryName().equals(Situation.DEPENDENCY_SITUATION_CATEGORY));

        // test situation object contents
        DependencySituation ds = (DependencySituation) sit.getSituationType();
        assertTrue(ds.getReasoningScope().equals(reasoning));
        assertTrue(ds.getDependencyDisposition().equals(de));
    }

    /**
     *
     */
    public void testSetDestroySituation() {
        String reasoning = "r";
        String su = "success";
        sit.setDestroySituation(reasoning, su);

        // test categoryName
        assertTrue(sit.getCategoryName().equals(Situation.DESTROY_SITUATION_CATEGORY));

        // test situation object contents
        DestroySituation ds = (DestroySituation) sit.getSituationType();
        assertTrue(ds.getReasoningScope().equals(reasoning));
        assertTrue(ds.getSuccessDisposition().equals(su));
    }

    /**
     *
     */
    public void testSetFeatureSituation() {
        String reasoning = "r";
        String fe = "feature";
        sit.setFeatureSituation(reasoning, fe);

        // test categoryName
        assertTrue(sit.getCategoryName().equals(Situation.FEATURE_SITUATION_CATEGORY));

        // test situation object contents
        FeatureSituation fs = (FeatureSituation) sit.getSituationType();
        assertTrue(fs.getReasoningScope().equals(reasoning));
        assertTrue(fs.getFeatureDisposition().equals(fe));
    }

    /**
     *
     */
    public void testSetOtherSituation() {
        String reasoning = "r";
        String an = "any";
        sit.setOtherSituation(reasoning, an);

        // test categoryName
        assertTrue(sit.getCategoryName().equals(Situation.OTHER_SITUATION_CATEGORY));

        // test situation object contents
        OtherSituation os = (OtherSituation) sit.getSituationType();
        assertTrue(os.getReasoningScope().equals(reasoning));
        assertTrue(os.getAny().equals(an));
    }

    /**
     *
     */
    public void testSetReportSituation() {
        String reasoning = "r";
        String re = "report";
        sit.setReportSituation(reasoning, re);

        // test categoryName
        assertTrue(sit.getCategoryName().equals(Situation.REPORT_SITUATION_CATEGORY));

        // test situation object contents
        ReportSituation rs = (ReportSituation) sit.getSituationType();
        assertTrue(rs.getReasoningScope().equals(reasoning));
        assertTrue(rs.getReportCategory().equals(re));
    }

    /**
     *
     */
    public void testSetRequestSituation() {
        String reasoning = "r";
        String si = "situation";
        String su = "success";
        sit.setRequestSituation(reasoning, si, su);

        // test categoryName
        assertTrue(sit.getCategoryName().equals(Situation.REQUEST_SITUATION_CATEGORY));

        // test situation object contents
        RequestSituation rs = (RequestSituation) sit.getSituationType();
        assertTrue(rs.getReasoningScope().equals(reasoning));
        assertTrue(rs.getSituationQualifier().equals(si));
        assertTrue(rs.getSuccessDisposition().equals(su));
    }

    /**
     *
     */
    public void testSetSituationType() {
        SituationType st = EventFactory.eINSTANCE.createRequestSituation();
        sit.setSituationType(st);
        assertTrue(sit.getSituationType() == st);

        SituationType st1 = EventFactory.eINSTANCE.createDependencySituation();
        sit.setSituationType(st1);
        assertTrue(sit.getSituationType() == st1);
    }

    public void testGetSituationType() {
        assertTrue(sit.getSituationType() == null);

        SituationType st = EventFactory.eINSTANCE.createStopSituation();
        sit.setSituationType(st);
        assertTrue(sit.getSituationType() == st);
    }

    public void testSetStartSituation() {
        String reasoning = "r";
        String si = "situation";
        String su = "success";
        sit.setStartSituation(reasoning, si, su);

        // test categoryName
        assertTrue(sit.getCategoryName().equals(Situation.START_SITUATION_CATEGORY));

        // test situation object contents
        StartSituation ss = (StartSituation) sit.getSituationType();
        assertTrue(ss.getReasoningScope().equals(reasoning));
        assertTrue(ss.getSituationQualifier().equals(si));
        assertTrue(ss.getSuccessDisposition().equals(su));
    }

    public void testSetStopSituation() {
        String reasoning = "r";
        String si = "situation";
        String su = "success";
        sit.setStopSituation(reasoning, si, su);

        // test categoryName
        assertTrue(sit.getCategoryName().equals(Situation.STOP_SITUATION_CATEGORY));

        // test situation object contents
        StopSituation ss = (StopSituation) sit.getSituationType();
        assertTrue(ss.getReasoningScope().equals(reasoning));
        assertTrue(ss.getSituationQualifier().equals(si));
        assertTrue(ss.getSuccessDisposition().equals(su));
    }

    /*
     * Test for String toString()
     */
    public void testToString() {
        assertNotNull(sit.toString());
    }

    /**
     * Tests the serialization
     */
    public void testSerialization() {
        Util.testEObjectSerialization(sit);
    }

    /**
     * Tests the <code>equals</code> operator.
     */
    public void testEquals() throws ValidationException {
        Situation sit2 = EventFactory.eINSTANCE.createSituation();

        sit.setStopSituation("reasoning", "UNSUCCESSFUL", "PAUSE INITIATED");
        sit.getSituationType().setReasoningScope("EXTERNAL");
        sit.validate();

        sit2 = (Situation) Util.clone(sit);
        assertEquals(sit, sit2);
        sit2.setCategoryName("ConnectSituation");
        assertFalse(sit.equals(sit2));

        sit2.setCategoryName("StopSituation");
        assertEquals(sit, sit2);
        sit.setStopSituation("r2", "SUCCESSFUL", "PAUSE INITIATED");
        assertFalse(sit.equals(sit2));

        sit = EventFactory.eINSTANCE.createSituation();
        sit2 = EventFactory.eINSTANCE.createSituation();
        sit.setCategoryName("StopSituation");
        sit.setStopSituation("r", "UNSUCCESSFUL", "PAUSE INITIATED");
        sit2.setCategoryName("StopSituation");
        assertFalse(sit.equals(sit2));
    }

    /**
     * Tests for missing attributes.
     */
    public void testValidationMissingAttributes() throws ValidationException {
        Util.assertMissingAttributes(sit, "all");

        sit.setStopSituation("r", "UNSUCCESSFUL", "PAUSE INITIATED");
        sit.setCategoryName("StopSituation");
        sit.validate();

        sit.setCategoryName(null);
        Util.assertMissingAttributes(sit, "categoryName");

        sit = EventFactory.eINSTANCE.createSituation();
        sit.setCategoryName("StopSituation");
        Util.assertMissingAttributes(sit, "situationType");
    }

    /**
     * Tests invalid data
     */
    public void testValidationInvalidData() {
        sit.setStopSituation("r", "UNSUCCESSFUL", "PAUSE INITIATED");
        sit.setCategoryName("xyz");
        try {
            sit.validate();
            fail("invalid categoryName");
        }
        catch (ValidationException exc) {
            Util.assertExceptionId("IWAT0199E", exc);
        }
    }

    /**
     * Tests whether invalid combinations of category and
     * situation type are accepted.
     */
    public void testCategoryTypeValidation() {
        sit.setAvailableSituation("r", "a", "b", "c");
        sit.setCategoryName(Situation.STOP_SITUATION_CATEGORY);
        assertCategory(sit);

        sit.setConfigureSituation("a", "b");
        sit.setCategoryName(Situation.STOP_SITUATION_CATEGORY);
        assertCategory(sit);

        sit.setConnectSituation("a", "b", "c");
        sit.setCategoryName(Situation.STOP_SITUATION_CATEGORY);
        assertCategory(sit);

        sit.setCreateSituation("b", "c");
        sit.setCategoryName(Situation.STOP_SITUATION_CATEGORY);
        assertCategory(sit);

        sit.setDependencySituation("a", "b");
        sit.setCategoryName(Situation.STOP_SITUATION_CATEGORY);
        assertCategory(sit);

        sit.setDestroySituation("a", "b");
        sit.setCategoryName(Situation.STOP_SITUATION_CATEGORY);
        assertCategory(sit);

        sit.setFeatureSituation("a", "b");
        sit.setCategoryName(Situation.STOP_SITUATION_CATEGORY);
        assertCategory(sit);

        sit.setOtherSituation("a", "b");
        sit.setCategoryName(Situation.STOP_SITUATION_CATEGORY);
        assertCategory(sit);

        sit.setReportSituation("a", "b");
        sit.setCategoryName(Situation.STOP_SITUATION_CATEGORY);
        assertCategory(sit);

        sit.setRequestSituation("a", "b", "c");
        sit.setCategoryName(Situation.STOP_SITUATION_CATEGORY);
        assertCategory(sit);

        sit.setStartSituation("a", "b", "c");
        sit.setCategoryName(Situation.STOP_SITUATION_CATEGORY);
        assertCategory(sit);

        sit.setStartSituation("a", "b", "f");
        sit.setCategoryName(Situation.AVAILABLE_SITUATION_CATEGORY);
        assertCategory(sit);
    }

    /*
     * Protected methods.
     */

    /**
     * 
     */
    protected void setUp() throws Exception {
        super.setUp();

        sit = EventFactory.eINSTANCE.createSituation();
    }

    /**
     * 
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * Private methods.
     */

    /**
     * Determines whether an improperly set category will trigger a 
     * validation exception. 
     */
    private void assertCategory(Situation sit) {
        try {
            sit.validate();
            fail("Category " + sit.getCategoryName() + " does not match the situation type " + sit.getSituationType());
        }
        catch (ValidationException exc) {
            Util.assertExceptionId("IWAT0211E", exc);
        }
    }
}
