package org.eclipse.hyades.logging.events.cbe.tests;

import java.io.Serializable;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.EventException;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventFactoryFactory;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EventFactoryFactoryTest.java,v 1.4 2005/04/28 14:49:00 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * JUnit test case for <code>EventFactoryFactory</code>.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1 
 * @since 1.0.1 
 */
public class EventFactoryFactoryTest extends TestCase {

    /**
     * Constructor for EventFactoryFactoryTest.
     * @param arg0
     */
    public EventFactoryFactoryTest(String arg0) {
        super(arg0);
    }

    /**
     *
     */
    public void testCreateEventFactory() {
        EventFactory ef = EventFactoryFactory.createEventFactory();
        ef.createCommonBaseEvent();
    }

    /**
     *
     */
    public void testCreateEventFactoryWithHandler() throws EventException {
        final String EXTENSION_NAME = "Example";
        ContentHandler mockHandler = new MockHandler(EXTENSION_NAME);
        EventFactory ef = EventFactoryFactory.createEventFactory(mockHandler);
        CommonBaseEvent cbe = ef.createCommonBaseEvent();
        cbe.complete();
        assertNotNull(cbe.getExtensionName());
        assertEquals(EXTENSION_NAME, cbe.getExtensionName());
    }

    /**
     * 
     */
    public class MockHandler implements ContentHandler, Serializable {

        /**
         * Stream-Unique IDentifier (SUID) of this class.
         * <p>
         * NOTE:  This value MUST not be modified unless an incompatible 
         *        change is introduced.  
         * <p>
         * See the 'Java Object Serialization Specification' for more details.
         * <p>
         * Compatible changes include:
         * <ul>
         * <li>Adding, modifying access or modifying <code>static</code>/<code>transient</code> to non-<code>static</code>/non-<code>transient</code> of fields.</li>
         * <li>Adding or removing classes.</li>
         * <li>Adding or removing <code>writeObject</code>/<code>readObject</code> methods.</li>
         * <li>Adding <code>java.io.Serializable</code> inheritance.</li>
         * </ul>
         * <p>
         * Incompatible changes include:
         * <ul>
         * <li>Deleting, modifying non-<code>static</code>/non-<code>transient</code> to <code>static</code>/<code>transient</code> or modifying the declared type of fields.</li>
         * <li>Modifying the hierarchy or interchanging/removing <code>java.io.Serializable</code>/<code>java.io.Externalizable</code> inheritance of the class.</li>
         * <li>Modifying <code>writeObject</code>/<code>readObject</code> methods.</li>
         * <li>Adding <code>writeReplace</code>/<code>readResolve</code> methods.</li>
         * </ul>
         */
        private static final long serialVersionUID = 2560066543377345030L;

        private String extensionName;

        public MockHandler(String name) {
            extensionName = name;
        }
        public void completeEvent(CommonBaseEvent event) throws CompletionException {
            event.setExtensionName(extensionName);
        }
    }

}
