/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLContiguousObservationLoader.java,v 1.5 2005/02/16 22:21:26 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.loaders.statistical;

import java.util.Iterator;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.StatisticalFactory;

/**
 * @author slavescu
 */
public class XMLContiguousObservationLoader extends SnapshotObservationBase {
	protected Double fValue;
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String elementName) {
		super.initialize(context, elementName);
		fValue = null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.statistical.SnapshotObservationBase#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		if (name.equals("value")) {
			fValue = Double.valueOf(value);
		} else
			super.addAttribute(name, value);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.statistical.SnapshotObservationBase#updateAttributes(org.eclipse.hyades.model.statistical.SDSnapshotObservation)
	 */
	protected void updateAttributes(SDContiguousObservation observation) {
		super.updateAttributes(observation);
		observation.getValue().add(fValue);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		super.addYourselfInContext();
		if(mMemberDescriptor==null)
			return;
		SDContiguousObservation observation = findContiguousObservation(mMemberDescriptor);
		if(observation==null)
		{
			observation = StatisticalFactory.eINSTANCE.createSDContiguousObservation();
			mMemberDescriptor.getSnapshotObservation().add(observation);
		}
		updateAttributes(observation);
	}

	/**
	 * @param memberDescriptor
	 * @return
	 */
	private SDContiguousObservation findContiguousObservation(SDMemberDescriptor descriptor) {
		for (Iterator iter = descriptor.getSnapshotObservation().iterator(); iter.hasNext();) {
			SDSnapshotObservation element = (SDSnapshotObservation) iter.next();
			
			//TODO: MS add support for multiple windows/views
			if(element instanceof SDContiguousObservation)
				return (SDContiguousObservation)element;
		}
		return null;
	}
	
}
