/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SDTextObservationImpl.java,v 1.10 2005/02/16 22:21:26 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.model.statistical.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.model.statistical.StatisticalPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>SD Text Observation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDTextObservationImpl#getTextValue <em>Text Value</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SDTextObservationImpl extends SDSnapshotObservationImpl implements SDTextObservation {
	/**
	 * The cached value of the '{@link #getTextValue() <em>Text Value</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTextValue()
	 * @generated
	 * @ordered
	 */
	protected EList textValue = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SDTextObservationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return StatisticalPackage.eINSTANCE.getSDTextObservation();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getTextValue() {
		if (textValue == null) {
			textValue = new EDataTypeEList(String.class, this, StatisticalPackage.SD_TEXT_OBSERVATION__TEXT_VALUE);
		}
		return textValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case StatisticalPackage.SD_TEXT_OBSERVATION__MEMBER_DESCRIPTOR:
					if (memberDescriptor != null)
						msgs = ((InternalEObject)memberDescriptor).eInverseRemove(this, StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION, SDMemberDescriptor.class, msgs);
					return basicSetMemberDescriptor((SDMemberDescriptor)otherEnd, msgs);
				case StatisticalPackage.SD_TEXT_OBSERVATION__WINDOW:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, StatisticalPackage.SD_TEXT_OBSERVATION__WINDOW, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case StatisticalPackage.SD_TEXT_OBSERVATION__MEMBER_DESCRIPTOR:
					return basicSetMemberDescriptor(null, msgs);
				case StatisticalPackage.SD_TEXT_OBSERVATION__WINDOW:
					return eBasicSetContainer(null, StatisticalPackage.SD_TEXT_OBSERVATION__WINDOW, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case StatisticalPackage.SD_TEXT_OBSERVATION__WINDOW:
					return ((InternalEObject)eContainer).eInverseRemove(this, StatisticalPackage.SD_SAMPLE_WINDOW__OBSERVATIONS, SDSampleWindow.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_TEXT_OBSERVATION__VALIDITY_MASK:
				return getValidityMask();
			case StatisticalPackage.SD_TEXT_OBSERVATION__CREATION_TIME:
				return getCreationTime();
			case StatisticalPackage.SD_TEXT_OBSERVATION__MEMBER_DESCRIPTOR:
				if (resolve) return getMemberDescriptor();
				return basicGetMemberDescriptor();
			case StatisticalPackage.SD_TEXT_OBSERVATION__WINDOW:
				return getWindow();
			case StatisticalPackage.SD_TEXT_OBSERVATION__TEXT_VALUE:
				return getTextValue();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_TEXT_OBSERVATION__VALIDITY_MASK:
				getValidityMask().clear();
				getValidityMask().addAll((Collection)newValue);
				return;
			case StatisticalPackage.SD_TEXT_OBSERVATION__CREATION_TIME:
				getCreationTime().clear();
				getCreationTime().addAll((Collection)newValue);
				return;
			case StatisticalPackage.SD_TEXT_OBSERVATION__MEMBER_DESCRIPTOR:
				setMemberDescriptor((SDMemberDescriptor)newValue);
				return;
			case StatisticalPackage.SD_TEXT_OBSERVATION__WINDOW:
				setWindow((SDSampleWindow)newValue);
				return;
			case StatisticalPackage.SD_TEXT_OBSERVATION__TEXT_VALUE:
				getTextValue().clear();
				getTextValue().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_TEXT_OBSERVATION__VALIDITY_MASK:
				getValidityMask().clear();
				return;
			case StatisticalPackage.SD_TEXT_OBSERVATION__CREATION_TIME:
				getCreationTime().clear();
				return;
			case StatisticalPackage.SD_TEXT_OBSERVATION__MEMBER_DESCRIPTOR:
				setMemberDescriptor((SDMemberDescriptor)null);
				return;
			case StatisticalPackage.SD_TEXT_OBSERVATION__WINDOW:
				setWindow((SDSampleWindow)null);
				return;
			case StatisticalPackage.SD_TEXT_OBSERVATION__TEXT_VALUE:
				getTextValue().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_TEXT_OBSERVATION__VALIDITY_MASK:
				return validityMask != null && !validityMask.isEmpty();
			case StatisticalPackage.SD_TEXT_OBSERVATION__CREATION_TIME:
				return creationTime != null && !creationTime.isEmpty();
			case StatisticalPackage.SD_TEXT_OBSERVATION__MEMBER_DESCRIPTOR:
				return memberDescriptor != null;
			case StatisticalPackage.SD_TEXT_OBSERVATION__WINDOW:
				return getWindow() != null;
			case StatisticalPackage.SD_TEXT_OBSERVATION__TEXT_VALUE:
				return textValue != null && !textValue.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (textValue: ");
		result.append(textValue);
		result.append(')');
		return result.toString();
	}

} //SDTextObservationImpl
