/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DBContentProvider.java,v 1.4 2005/02/16 22:21:33 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.editors;

import java.util.*;

import org.eclipse.hyades.models.internal.sdb.*;
import org.eclipse.jface.viewers.*;

public class DBContentProvider implements ITreeContentProvider
{
  private Object[] objList;

public DBContentProvider()
{
}


  public Object[] getChildren(Object element)
  {
	return getElements(element);
  }  
  
  
  public Object[] getElements(Object elem)
  {
	    final Object element = elem;
	    
	    if (element instanceof SDBRuntime)
			org.eclipse.swt.custom.BusyIndicator.showWhile(null, new Runnable()
			{
				public void run() {			
					try
					{
					  objList = ((SDBRuntime)element).getSymptoms().toArray();
					}
					catch (Exception e)
					{
					  e.printStackTrace();
					}
				}
			});			
		else if(element instanceof SDBSymptom)
			objList = ((SDBSymptom)element).getSolutions().toArray();
		else if (element instanceof SDBSolution)
			objList = ((SDBSolution)element).getDirectives().toArray();
		else if (element instanceof Object[])
			objList = (Object[]) element;			
		else
		    objList = null;  				      	


		if(objList == null)
			  return (new Vector()).toArray();

		  
		return objList;
  }  
  public Object getParent(Object element)
  {
	return null;
  }  
    
  public boolean hasChildren(Object element)
  {
	  return (getChildren(element).length > 0);
  }  
  
  public void dispose()
  {
  }
  
  public void inputChanged(Viewer viewer,	Object oldInput, Object newInput)
  {
  }  
  
}
