/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ContextIds.java,v 1.4 2005/02/16 22:21:33 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.help;

import org.eclipse.hyades.sdb.internal.SDbPlugin;

public interface ContextIds {
	// Constant for the RAS plug-in id.
	public static final String PLUGIN_ID = SDbPlugin.getPluginId();

	public static final String SYMDB_PREF_DATABASE = PLUGIN_ID + ".sdpp0010";
	public static final String SYMDB_PREF_DATABASE_ADD_DIALOG = PLUGIN_ID + ".sdpp0020";

	// Context help ID constants for the Symptom Database preferences page.
	public static final String SYMDB_PREF_URL = PLUGIN_ID + ".sdpp0110";
	public static final String SYMDB_PREF_URL_ADD_DIALOG_NAME = PLUGIN_ID + ".sdpp0120";
	public static final String SYMDB_PREF_URL_ADD_DIALOG_URL = PLUGIN_ID + ".sdpp0130";
	public static final String SYMDB_PREF_URL_EDIT_DIALOG_NAME = PLUGIN_ID + ".sdpp0140";
	public static final String SYMDB_PREF_URL_EDIT_DIALOG_URL = PLUGIN_ID + ".sdpp0150";

	// Context help ID constants for creating new Symptom Database file.
	public static final String NEW_SYMDB_LOCATION = PLUGIN_ID + ".nsdb0010";
	public static final String NEW_SYMDB_NAME = PLUGIN_ID + ".nsdb0020";
	public static final String NEW_SYMDB_DESCRIPTION = PLUGIN_ID + ".nsdb0030";
	public static final String NEW_SYMDB_CREATE_FOLDER = PLUGIN_ID + ".nsdb0040";

	// Context help ID constants for exporting Symptom Database file.
	public static final String EXPORT_SYMDB_RESOURCE = PLUGIN_ID + ".esdb0010";
	public static final String EXPORT_SYMDB_DESTINATION = PLUGIN_ID + ".esdb0020";
	public static final String EXPORT_SYMDB_XML_FORMAT = PLUGIN_ID + ".esdb0030";
	public static final String EXPORT_SYMDB_OVERWRITE_FILE = PLUGIN_ID + ".esdb0040";

	// Context help ID constants for importing Symptom Database file.
	public static final String IMPORT_SYMDB_HOST_LOCAL = PLUGIN_ID + ".isdb0010";
	public static final String IMPORT_SYMDB_HOST_REMOTE = PLUGIN_ID + ".isdb0020";
	public static final String IMPORT_SYMDB_LOCATION = PLUGIN_ID + ".isdb0030";
	public static final String IMPORT_SYMDB_FILE = PLUGIN_ID + ".isdb0040";
	public static final String IMPORT_SYMDB_OVERRIDE_RESOURCE = PLUGIN_ID + ".isdb0050";
	public static final String IMPORT_SYMDB_CREATE_FOLDER = PLUGIN_ID + ".isdb0060";

	// Context help ID constants for the Symptom Database editor.
	public static final String SYMDB_EDITOR_PAGE_OVERVIEW = PLUGIN_ID + ".sdbe0010";
	public static final String SYMDB_EDITOR_PAGE_DETAILS = PLUGIN_ID + ".sdbe0020";
	public static final String SYMDB_EDITOR_DETAILS_NAME = PLUGIN_ID + ".sdbe0110";
	public static final String SYMDB_EDITOR_DETAILS_URL = PLUGIN_ID + ".sdbe0120";
	public static final String SYMDB_EDITOR_DETAILS_LOCATION = PLUGIN_ID + ".sdbe0130";
	public static final String SYMDB_EDITOR_DETAILS_DESCRIPTION = PLUGIN_ID + ".sdbe0140";
	public static final String SYMDB_EDITOR_SYMPTOM = PLUGIN_ID + ".sdbe0210";
	public static final String SYMDB_EDITOR_SYMPTOM_DESCRIPTION = PLUGIN_ID + ".sdbe0220";
	public static final String SYMDB_EDITOR_SOLUTION = PLUGIN_ID + ".sdbe0310";
	public static final String SYMDB_EDITOR_SOLUTION_DESCRIPTION = PLUGIN_ID + ".sdbe0320";
	public static final String SYMDB_EDITOR_DIRECTIVE = PLUGIN_ID + ".sdbe0410";
	public static final String SYMDB_EDITOR_DIRECTIVE_DESCRIPTION = PLUGIN_ID + ".sdbe0420";
	public static final String SYMDB_EDITOR_DIRECTIVE_FFDC = PLUGIN_ID + ".sdbe0430";
	public static final String SYMDB_EDITOR_POPUP_ADD_SYMPTOM = PLUGIN_ID + ".sdbe0510";
	public static final String SYMDB_EDITOR_POPUP_ADD_SOLUTION = PLUGIN_ID + ".sdbe0520";
	public static final String SYMDB_EDITOR_POPUP_ADD_DIRECTIVE = PLUGIN_ID + ".sdbe0530";
	public static final String SYMDB_EDITOR_POPUP_DELETE = PLUGIN_ID + ".sdbe0540";
	public static final String SYMDB_EDITOR_FIND_WHAT = PLUGIN_ID + ".sdbe0610";
	public static final String SYMDB_EDITOR_FIND_CASE = PLUGIN_ID + ".sdbe0620";
}
