/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SymptomDBPreferencePage.java,v 1.10 2005/05/06 04:05:42 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.preferences;

import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.ui.internal.util.PreferencesUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * The page for setting java plugin preferences.
 */
public class SymptomDBPreferencePage
	extends PreferencePage
	implements IWorkbenchPreferencePage {

	private SymptomDBUI _options;

	public SymptomDBPreferencePage() {
		super();
		setPreferenceStore(PreferencesUtil.doGetPreferenceStore());
	}
	protected Control createContents(Composite parent) {
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
		SDbPlugin.getPluginId()+".sypp0000");
		
		Composite composite = new Composite(parent, SWT.NONE);

		GridData data = GridUtil.createFill();
		data.heightHint = 100;
		composite.setLayoutData(data);
		GridLayout layout = new GridLayout();
		layout.marginWidth = 10;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);

		_options = new SymptomDBUI();
		_options.createControl(composite);

		initializeValues();

		return composite;
	}
	public void init(IWorkbench workbench) {
	}
	/**
	 * Initializes states of the controls using default values
	 * in the preference store.
	 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();

		_options.addDBPath(store.getDefaultString(PreferencesUtil.SYMPTOM_DB_PATH_KEY));
	}
	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues() {
		IPreferenceStore store = getPreferenceStore();

		_options.addDBPath(store.getString(PreferencesUtil.SYMPTOM_DB_PATH_KEY));
	}
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults() {
		super.performDefaults();
		initializeDefaults();
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		storeValues();
		PreferencesUtil.savePreferences();
		return true;
	}
	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private void storeValues() {
		_options.storeValues(getPreferenceStore());
	}
}