/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SymptomDBDrillDownAdapter.java,v 1.4 2005/02/16 22:21:33 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.util;

import org.eclipse.ui.part.*;
import org.eclipse.jface.viewers.*;

/**
 * Implements a simple web style navigation metaphor for a <code>TreeViewer</code>.  
 * Home, back, and "drill into" functions are supported for the viewer,
 * <p>
 */
public class SymptomDBDrillDownAdapter extends DrillDownAdapter 
{
/**
 * Allocates a new DrillDownTreePart.
 *
 * @param tree the target tree for refocusing
 */
public SymptomDBDrillDownAdapter(TreeViewer tree)
{
	super(tree);
}
/**
 * Returns whether "go into" is possible for child tree.  This is only possible 
 * if the current selection in the client has one item and it has children.
 *
 * @return <code>true</code> if "go into" is possible; <code>false</code> otherwise
 */
public boolean canGoInto()
{
	try {
		return super.canGoInto();
	}
	catch(Exception exc)
	{
		return false;
	}
}
}
