/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExportSymptomDBWizard.java,v 1.4 2005/02/16 22:21:33 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.wizard;

import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

import org.eclipse.hyades.sdb.internal.SDbPlugin;

public class ExportSymptomDBWizard extends Wizard implements IExportWizard{

	private ExportSymptomDBWizardPage page;
	private IFile selFile;

	public ExportSymptomDBWizard() {
		super();
		setNeedsProgressMonitor(true);
	}

	public IFile getFile(){
		return selFile;
	}
	
	public void addPages() {
		setWindowTitle(
			SDbPlugin.getResourceString("STR_EXPORT_SYMPTOM_DB_WIZARD_TITLE"));

		super.addPages();
		page =
			new ExportSymptomDBWizardPage(
				SDbPlugin.getResourceString("STR_EXPORT_SYMPTOM_DB_PTITLE"));
		addPage(page);
	}
	
	public void init(IWorkbench workbench, IStructuredSelection selection){

	    if (selection instanceof IStructuredSelection) {
	        Iterator enum = selection.iterator();
	        if (enum.hasNext()) {
	            Object obj = enum.next();
	            if (enum.hasNext()) // implies > 1 elements selection in tree, so we don't populate with selection
	                selFile = null;
	            else {
	                IResource r = null;
	                if (obj instanceof IResource)
	                    r = (IResource)obj;
	
	                // pre-populate the wizard with the sel. resource (project, folder) or the container of the sel. resource(file)
	                if (r != null){
	                	if(r.getType() == IResource.FILE)
	                	{
	                    	selFile = (IFile)r;
	                	}
	                	else{
	                		selFile = null;
	                	}
	                	
	                }
	                		                    
	            }
	        }
	    }

	}
	
	public boolean performFinish() {
		return page.performFinish();
	}
}
