/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RecordTraceStart.java,v 1.3 2005/02/16 22:20:27 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.trace.util;


/**
 * This is the record for a trace start.  For up-to-date descriptions of the tag attributes,
 * see Event Specification for the Java Profiler at <code>http://www.eclipse.org/hyades</code>.
 * 
 * @author Richard Duggan, Qiyan Li
 */
public class RecordTraceStart {

    private final String traceId;
    private final String agentIdRef;
    private final String time;
    private String collationValue = null;


    /**
     * Creates a record for a new trace.
     * 
     * @param agentIdRef    the UUID of the agent
     */
    public RecordTraceStart(String agentIdRef) {

        traceId = Long.toString(this.hashCode());
        this.agentIdRef = agentIdRef;
        this.time = Utilities.getCurrentTimeStamp();
    }


    /**
     * Converts this record into a string.
     * 
     * @return  this record as a string
     */
    public String toString() {

        return "<traceStart traceId=\"" + traceId + "\" agentIdRef=\"" + agentIdRef +
               "\" time=\"" + time + "\"" +
               (collationValue == null ? "" : " collationValue=\"" + collationValue + "\"") + "/>";
    }


    public String getAgentIdRef() {
        return agentIdRef;
    }


    public String getCollationValue() {
        return collationValue;
    }


    public String getTime() {
        return time;
    }


    public String getTraceId() {
        return traceId;
    }


    public void setCollationValue(String collationValue) {
        this.collationValue = collationValue;
    }
}
