/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: TaTosWeightGridElement.java,v 1.5 2005/02/16 22:19:54 qiyanli Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.collection.threadanalyzer;



public class TaTosWeightGridElement implements TaGridElement
{
   public TaTosWeightGridElement( int weight, Object additionalInfo )
   {
      _weight = weight;
      _additional = additionalInfo;
   }
   private TaTosWeightGridElement()
   {
   }
   
   public String toString()
   {
      return ""+_weight;
   }

   public int compareTo( TaGridElement g )
   {
      TaTosWeightGridElement e = (TaTosWeightGridElement)g;
      int iRet = 1;
      if( e._weight == _weight )
         iRet = 0;
      else if( e._weight < _weight )
         iRet = -1;
      return iRet;
   }
   
   public Object getAdditionalInfo()
   {
      return _additional;
   }

   private Object _additional = null;
   private int _weight = 0;
}

