/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: DumpParserLinux131_Suse_cxppc.java,v 1.5 2005/02/16 22:19:54 qiyanli Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
/*
 * DumpParser - IBM, April 2003
 */

package org.eclipse.hyades.collection.threadanalyzer.dumpparser;

import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.StkEntryNative;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.TaException;
import org.eclipse.hyades.collection.threadanalyzer.Thd;


public class DumpParserLinux131_Suse_cxppc extends DumpParser
{

   public DumpParserLinux131_Suse_cxppc ()
   {

   }

   public void parse( DumpData d )
   throws Exception
   {
      logDebug( "parse thread dump compatible with IBM Linux/Suse cxppc build" );

      try
      {
         if( _r.ready() )
         {
            String s = _r.readLine(); // date

            getThreadData( d );
            //d.setThreadTypes(); // after reading all threads, set their type
            resetFileReader(); // new format for JDK thread info on the back
            getMonitorPoolStats( d ); // just skips unneeded data
            getMonitors( d );
            getHeapLockWaiters( d ); // warning -- skips a significant portion of file

                        //dipak
                        // this line was added below in order to get remainder of file
            while( getLine (d) != null )
            {
            }

         }
      }
      catch( Exception e )
      {
         _lineNo++;
                 logErr( TAUtils.getNLSValue("ta.errmsg.ExceptionWhileParsing", "exception while parsing line") + ": " + _lineNo + " -- " + _dumpInName );
         throw new TaException(""+_lineNo, e);
      }

   }

   private void getHeapLockWaiters( DumpData d ) throws Exception
   {

      String line = getLine( d );

      if( line == null ) return;
      while( line.indexOf( "Heap lock" ) < 0 )
      {
         logDebug( line );
         line = getLine( d );
      }
      line = getLine( d );
      if( line.indexOf( "Waiting to enter:" ) >= 0 ||
          line.indexOf( "Waiting to be notified" ) >= 0 )
      {
         Monitor m = d.addMonitor( "HEAP_LOCK", Monitor.WAIT_MONITOR ); // don't know actual type yet.
         line = getLine( d );
         logDebug( TAUtils.getNLSValue("ta.msg.HeapLockWaiters", "Heap lock waiters") + ": " );
         while( line.charAt( 0 ) == '\t' )
         {
            logDebug( " -- " + line );
            String thdId = null;
            int idx1 = line.indexOf( '(' );
            thdId = line.substring( idx1+1, line.indexOf( ')' ));
            Thd t = d.getThd( thdId );
            m.addWaiter( t );
            logDebug( "  *" + thdId + "*" );
            line = getLine( d );
         }
      }
   }

   private void getMonitorPoolStats( DumpData d ) throws Exception
   {
      String line = null;
      line = getLine( d );
      //dipak
      //while( line != null && line.length() > 0 )
      while( line != null && line.indexOf( "Monitor Pool Dump" ) == -1 )
      {
         line = getLine( d );
      }
   }

   private void getMonitors( DumpData d ) throws Exception
   {
      boolean done = false;
      String line = null;
      //dipak - commented between /* */ since that logic does not work
      /*line = getLine( d );  // strip off the heading line
      if( line == null )
         return;
      // throw away first line */
      line = getLine( d );
      if( line == null )
         return;
      while( ! done )
      {

         // second line contains monitor name and owner info
         line = getLine( d );
         if( line == null || line.indexOf( "NULL" ) != -1 )
            continue;
         //System.out.println( line );
         if (line.indexOf("JVM System Monitor Dump") != -1)
         {
            done = true;
            continue;
         }
         int idx1 = line.indexOf( ':' );
         String monitor = line.substring( 0, idx1 );
         monitor.trim();
         Monitor m = d.addMonitor( monitor, Monitor.WAIT_MONITOR ); // don't know actual type yet.

         logDebug( " -" + TAUtils.getNLSValue("ta.string.monitor", "monitor") + " " + monitor );
         line = getLine( d );
                 //dipak -      changes (starting here) were commented and replaced in order 
                 //                     to make it work.
         //while( line.length() > 0 && line.charAt(0) == '\t' )
         //{
            if( line.indexOf( "Waiting to be notified" ) != -1 ||
                line.indexOf( "Waiting to enter:" ) != -1 
              )
            {
               // throw away "waiting to (enter | be notified):"         
               // get the first waiter or first line of next monitor
               line = getLine( d );
            }
            //dipak - replaced above line that was commented
                        while ( line.trim().length() > 0 && line.trim().charAt(0) == '\"' )
                        {            
            if( line.length() > 0 && line.charAt(0) == '\t' )
            {

               logDebug( " -- " + TAUtils.getNLSValue("ta.string.waiter", "waiter") + " " + line );
               String thdId = null;
               idx1 = line.lastIndexOf( '(' );
               thdId = line.substring( idx1+1, line.lastIndexOf( ')' ));
               logDebug( "\ttid=" + thdId );
               Thd t = d.getThd( thdId );
               m.addWaiter( t );
               // get next waiter or first line of next monitor
               line = getLine( d );
            }
         }

                //dipak 
                //if( line.trim().length() == 0 )
         if( line.trim().equals("") || line.indexOf("JVM System Monitor Dump") != -1) 
            done = true;
      }
   }


   private void getThreadData( DumpData d ) throws Exception
   {
      String line = null;
      char firstChar = 0;
      line = getLine( d );
      Thd thd = null;

          // Skip to beginning of thread data
      while( line.indexOf( "Full thread dump" ) == -1 )
         line = getLine( d );

          // Find first opening quote
      while( line.indexOf( "\"" ) == -1 )
         line = getLine( d );


          // Do until end of thread data section
      while( line != null && line.indexOf( "CL subcomponent" ) == -1 )
      {
                 // Gobble lines until we find one with a quote
         while( line !=null && line.indexOf( "sys_thread_t" ) == -1 && line.indexOf( "CL subcomponent" ) == -1 )
            line = getLine( d );

                 // If it's end of the thread data section then BREAK
         if( line != null && line.indexOf( "CL subcomponent" ) != -1 )
            break;

                 // Process lines until we hit Native Stack data
         while( line != null 
                  && line.length() > 0 
                  && line.indexOf( "Native Stack of" ) == -1 
              )
         {
            //firstChar = line.charAt( 0 );
            if( line.indexOf("sys_thread_t") != -1 ) // new thread
            {
               int idx1 = line.indexOf( '\"' );
               int idx2 = line.indexOf( '\"', idx1+1 );
               String thdNm = line.substring( idx1+1, idx2 );
               idx1 = line.indexOf( "sys_thread_t:" );
               String line2 = line.substring( idx1 );
               idx2 = line2.indexOf( ',' );
               String threadId = line2.substring( 13, idx2 );
               idx1 = line.indexOf( "state:" )+6; 
               idx2 = line.indexOf( ',', idx1 );
               String state = line.substring( idx1, idx2 );
               idx1 = line.indexOf( "prio=" );
               String priority = line.substring( idx1+5 );
               logDebug( thdNm + " - " + threadId + " - " + state + " - " + priority );
               thd = d.addThd( thdNm, threadId, state, priority );
            }
            else if( line.indexOf(" at ") != -1 )// thread stack entry
            {
               if( line.indexOf("...") == -1 
                    && line.indexOf( ", sp =" ) == -1 
                    && line.indexOf( "javacore" ) == -1
                  )
               {

                  String line2 = line.substring( line.indexOf( " at " )+4 );
                  
                  boolean isNative = false;
                  String moduleName = null;
                  String lineno = null;

                                  // Native Method call
                  int idx1 = line2.indexOf( "(Native Method)" );
                  if( idx1 > 0 )
                  {
                     isNative = true;

                     line2 = line2.substring( 0, idx1 );
                  }

                                  // Java Method call
                  else
                  {
                     idx1 = line2.indexOf( "(" );
                     ++idx1;

                                         // source file & line number
                     String moduleInfo = line2.substring( idx1 );
                                         logDebug( "Parsing moduleInfo: " + moduleInfo );

                                         // method call
                     line2 = line2.substring( 0, idx1-1 );

                     int idx2 = moduleInfo.indexOf( ':' );

                                         // moduleInfo has a line number
                     if( idx2 > 0 )
                     {
                        lineno = moduleInfo.substring( idx2+1, moduleInfo.indexOf( ')', idx2)-1 );
                        moduleName = moduleInfo.substring( 0, idx2 ); 
                                                logDebug( "Found moduleName: " + moduleName + "  lineno: " + lineno );
                     }
                                         // no line number
                     else
                     {
                        idx2 = moduleInfo.indexOf( '(' );
                        if( idx2 == -1 )
                           idx2 = moduleInfo.indexOf( ')' );
                        moduleName = moduleInfo.substring( 0, idx2 );
                                                logDebug( "Found moduleName: " + moduleName + "  and no line number..." );
                     }
                  }
                  String method = line2.substring( line2.lastIndexOf( '.' ) + 1 );
                  String pkg = line2.substring( 0, line2.lastIndexOf( '.' ) );
                  int iLineNo = -1;
                  if( lineno != null )
                  {
                     iLineNo = Integer.parseInt( lineno );
                  }
                  StkEntry se = new StkEntry( method, pkg, moduleName, iLineNo, isNative );
                  logDebug( "  -- " + pkg + " . " + method + " - "  +  " - " + moduleName + " - " + lineno + " - " + isNative );
                  thd.addStackEntry( se );
               }
            }
            line = getLine( d );
         }

         line = getLine( d );
         
         if ( line != null )
         {
            while( line.indexOf("----") == -1 )
            {
                /*
                 *   Not parsing out into separate elements for right now.  Maybe later...
                 */
   
   
                /*
                int iHexStart = line.indexOf("at") + 3;
                int iHexEnd   = line.indexOf(" ", iHexStart);
   
                String sHex      = line.substring( iHexStart, iHexEnd ); 
                String sFunction = line.substring( line.indexOf("in")+3 );
   
                if( line.indexOf("allegedly") == -1 && line.indexOf("unavailable") == -1 )
                {
                    StkEntryNative sen = new StkEntryNative( sFunction, sHex );
                    logDebug( "  -- " + sHex + " -- " + sFunction );
                    thd.addStackEntryNative( sen );
                }
                else
                {
                */
                    StkEntryNative sen = new StkEntryNative( null, line.trim() );
                    logDebug( "  -- " + line );
                    thd.addStackEntryNative( sen );
                //}
   
                line = getLine( d );
            }
         }

      }
   }



}

