/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: DumpParser_a118_20010215a.java,v 1.5 2005/02/16 22:19:54 qiyanli Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
/*
 * DumpParser - IBM, March 2001
 */

package org.eclipse.hyades.collection.threadanalyzer.dumpparser;

import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.TaException;
import org.eclipse.hyades.collection.threadanalyzer.Thd;


public class DumpParser_a118_20010215a extends DumpParser
{

   public DumpParser_a118_20010215a( )
   {
   }

   public void parse( DumpData d )
   throws Exception
   {
       logDebug( TAUtils.getNLSValue("ta.msg.ParsingDumpOutputFor.a118", "parsing dumpthreads output for build compatible with a118-20010215a") );
       try
       {
          if( _r.ready() )
          {
             String s = _r.readLine(); // version
             //getEnvData( d );
             getThreadData( d );
             //getMonitorPoolStats( d ); // just skips unneeded data
             getMonitors( d );
             //getHeapLockWaiters( d ); // warning -- skips a significant portion of file

          }
       }
       catch( Exception e )
       {
		  logErr( TAUtils.getNLSValue("ta.errmsg.ExceptionWhileParsing", "exception while parsing line") + ": " + _lineNo + " -- " + _dumpInName );
          throw new TaException(""+_lineNo, e);
       }
       
   }



   private void getThreadData( DumpData d ) throws Exception
   {
      // d111401 -- RE strRE = new RE( "\"(.*)\"" );
      // d111401 -- RE tidRE = new RE( "TID:(.*)," );
      // d111401 -- RE prioRE = new RE( "prio=(.*?)($|\\s)" );   // non-greedy closure
      String line = null;
      char firstChar = 0;
      line = getLine( d );
      Thd thd = null;

      // skip to the thread dump
      while( _r.ready() && line.indexOf( "Full thread dump:" ) == -1 )
      {
         logDebug( line );
         line = getLine( d );
      }

      String tid = null;
      String thdName = null;
      String state = null;
      while( _r.ready() && line.indexOf( "System Monitor Status" ) == -1 )
      {
         int idx1 = 0;
         if( ( idx1 = line.indexOf( "\"" )) > -1  )
         {
            int idx2 = line.lastIndexOf( "\"" );

            thdName = line.substring( idx1+1, idx2 );
            

            idx1 = line.indexOf( "TID:" );
            //tidRE.match( line );  --d111401
            //tid = tidRE.getParen( 1 ); --d111401
            idx2 = line.indexOf( "," );
            tid = line.substring( idx1+4, idx2 );

            line = getLine( d );
            state = null;
            if( line.endsWith( "MONITOR WAIT" ))
               state = "MW";
            else if( line.endsWith( "SUSPENDED" ))
               state = "S";
            else if( line.endsWith( "RUNNING" ))
               state = "R";
            else if ( line.endsWith( "WAIT" )) 
               state = "CW";
            else state = "?";

            while( _r.ready() && line.indexOf( "------ Java stack ------" ) == -1 )
               line = getLine( d );
   
            String prio = "?";
            /* d111401
            if( prioRE.match( line ) )
            {
               prio = prioRE.getParen( 1 );
            }
            */
            idx1 = line.indexOf( "prio=" );
            if( idx1 > -1 )
            {
               idx2 = line.substring( idx1 ).indexOf( " " );
               if( idx2 > -1 )
                  prio = line.substring( 5, idx2 );
               else prio = line.substring( idx1+5 );
            }
            logDebug( thdName + " (" + tid + ") " + state + "  " + prio);
            Thd t = d.addThd( thdName, tid, state, prio );

            line = getLine( d );

            // get the thread stack
            while( _r.ready() && !line.startsWith( "--" ))
            {
               /* d111401
               RE seRE = new RE( "(.*)\\(" );
               RE se2RE = new RE( ".*\\((.*)\\)" );
               seRE.match( line );

               se2RE.match( line );
               String fqMethod = seRE.getParen( 1 );
               String moduleInfo = se2RE.getParen( 1 );
               */

               String fqMethod = line.substring( 0, line.indexOf( "(" )); 
               fqMethod = fqMethod.trim();

               String moduleInfo = line.substring( line.indexOf( "(" )+1, line.lastIndexOf( ")" ));

               String pkg = fqMethod.substring( 0, fqMethod.lastIndexOf( '.' ));
               String method = fqMethod.substring( fqMethod.lastIndexOf( '.' )+1 );
               
               String module = null;
               String sLineNo = null;
               int lineNo = -1;
               int idx = moduleInfo.indexOf( ':' );
               if( idx != -1 )
               {
                  module = moduleInfo.substring( 0, idx );
                  sLineNo = moduleInfo.substring( idx+1 );
               }
               else if( !moduleInfo.equals( "compiled code" ))
                  module = moduleInfo;

               if( sLineNo != null )
                  lineNo = Integer.parseInt( sLineNo );

               logDebug( "\t" + pkg + " . " + method + " --" + module + "%" + lineNo + "*"+ moduleInfo );
               StkEntry se = new StkEntry( method, pkg, module, lineNo, false );
               t.addStackEntry( se );
               line = getLine( d );
               logDebug( line );
            }

         }


         line = getLine( d );
      }

      logDebug( line );
   }

   private void getMonitors( DumpData d ) throws Exception
   {
      String line = getLine( d );

      // skip to the monitor
      while( _r.ready() && line.indexOf( "Object Monitor Status" ) == -1 )
      {
         logDebug( line );
         line = getLine( d );
      }

      line = getLine( d ); // skip the dashes
      Monitor m = null;
      line = getLine( d ); // get first monitor

      while( _r.ready() && line.length() > 0 )
      {
         if( line.charAt(0) != '\t' )
         {
            logDebug(  line );
            String monName = line.substring( 0, line.indexOf( ':' ));
            monName = monName.trim();
            logDebug( TAUtils.getNLSValue("ta.string.monitor", "monitor") + " - " + monName );
            m = d.addMonitor( monName, Monitor.WAIT_MONITOR );
         }
         else
         {
            logDebug( TAUtils.getNLSValue("ta.string.waiter", "waiter") + " - " + line );
            String tid = line.substring( line.indexOf( "(" )+1, line.indexOf( ")" ));

            // d111401 -- RE tidRE = new RE( "\\((.*)\\)" );
            // d111401 -- tidRE.match( line );
            // d111401 -- String tid = tidRE.getParen( 1 );

            Thd t = d.getThd( tid );
            
            m.addWaiter( t );
         }
         line = getLine( d );
      }
      
   }

}

