/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: DumpParser_ca122_20001026b.java,v 1.5 2005/02/16 22:19:54 qiyanli Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
/*
 * DumpParser - IBM, March 2001
 */

package org.eclipse.hyades.collection.threadanalyzer.dumpparser;

import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.StkEntryNative;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.TaException;
import org.eclipse.hyades.collection.threadanalyzer.Thd;


public class DumpParser_ca122_20001026b extends DumpParser
{

   public DumpParser_ca122_20001026b( )
   {

   }

   public void parse( DumpData d )
   throws Exception
   {
      logDebug( TAUtils.getNLSValue("ta.msg.ParsingDumpOutputFor.ca122", "parse thread dump compatible with ca122-20001026b") );
      try
      {
         if( _r.ready() )
         {
            String s = _r.readLine(); // date
            getThreadData( d );
            //d.setThreadTypes(); // after reading all threads, set their type
            getMonitorPoolStats( d ); // just skips unneeded data
            getMonitors( d );
            getHeapLockWaiters( d ); // warning -- skips a significant portion of file

            //dipak added below line in order to obtain the rest of the dump files into memory.
            while( getLine (d) != null ) {}

         }
      }
      catch( Exception e )
      {
         logErr( TAUtils.getNLSValue("ta.errmsg.ExceptionWhileParsing", "exception while parsing line") + ": " + _lineNo + " -- " + _dumpInName );
         throw new TaException(""+_lineNo, e);
      }

   }

   private void getHeapLockWaiters( DumpData d ) throws Exception
   {

      String line = getLine( d );
      if( line == null ) return;

      while( line.indexOf( "Heap lock:" ) < 0 )
      {
         logDebug( line );
         line = getLine( d );
         if( line == null ) return;
      }
      line = getLine( d );
      if( line.indexOf( "Waiting to enter:" ) >= 0 ||
          line.indexOf( "Waiting to be notified:" ) >= 0 )
      {
         Monitor m = d.addMonitor( "HEAP_LOCK", Monitor.WAIT_MONITOR ); // don't know actual type yet.
         line = getLine( d );
         logDebug( TAUtils.getNLSValue("ta.logdebug.HeapLockWaiters", "Heap lock waiters") + ": " );
         while( line.charAt( 0 ) == '\t' )
         {
            logDebug( " -- " + line );
            String thdId = null;
            int idx1 = line.indexOf( '(' );
            thdId = line.substring( idx1+1, line.indexOf( ')' ));
            Thd t = d.getThd( thdId );
            m.addWaiter( t );
            logDebug( "  *" + thdId + "*" );
            line = getLine( d );
         }
      }
   }

   private void getMonitorPoolStats( DumpData d ) throws Exception
   {
      String line = null;
      line = getLine( d );
      while( line != null && line.indexOf("Monitor Pool Dump") == -1 )
      {
         line = getLine( d );
      }
   }

   private void getMonitors( DumpData d ) throws Exception
   {
      boolean done = false;
      String line = null;

      // throw away first line
      line = getLine( d );
      while( ! done && line != null && line.length() > 0 )
      {
          // second line contains monitor name and owner info
          line = getLine( d );

         int idx1 = line.indexOf( ':' );
         String monitor = line.substring( 0, idx1 );
         monitor.trim();
         Monitor m = d.addMonitor( monitor, Monitor.WAIT_MONITOR ); // don't know actual type yet.

         logDebug( " -" + TAUtils.getNLSValue("ta.string.monitor", "monitor") + " " + monitor );
         line = getLine( d );

         while( line.length() > 0 && line.charAt(0) == '\t' )
         {
            if( line.indexOf( "Waiting to be notified" ) != -1 ||
                line.indexOf( "Waiting to enter:" ) != -1 
              )
            {
               // throw away "waiting to (enter | be notified):"         
               // get the first waiter or first line of next monitor
               line = getLine( d );
            }
            if( line.length() > 0 && line.charAt(0) == '\t' )
            {

               logDebug( " -- " + TAUtils.getNLSValue("ta.string.waiter", "waiter") + " " + line );
               String thdId = null;
               idx1 = line.lastIndexOf( '(' );
               thdId = line.substring( idx1+1, line.lastIndexOf( ')' ));
               logDebug( "\ttid=" + thdId );
               Thd t = d.getThd( thdId );
               m.addWaiter( t );
               // get next waiter or first line of next monitor
               line = getLine( d );
            }
         }

         //System.out.println("index: " + line.indexOf("JVM System Monitor Dump") );

         if( line.indexOf("JVM System Monitor Dump") != -1 )
         {
            done = true;
         }

         /*
         if( line.length() == 0 )
            done = true;
            */
      }
   }


   private void getThreadData( DumpData d ) throws Exception
   {
      String line = null;
      char firstChar = 0;
      line = getLine( d );
      Thd thd = null;

      while( line != null && line.indexOf( "Loaded Libraries" ) == -1 )
         line = getLine( d );

      while( line != null && line.indexOf( "Monitor pool info:" ) == -1 )
      {

         while( line != null &&  line.indexOf( "\"" ) == -1 && line.indexOf( "Monitor pool info:" ) == -1 )
            line = getLine( d );

         if( line != null && line.indexOf( "Monitor pool info:" ) != -1 )
            break;

                 int linecount = 0;

         while( line != null && line.length() > 0 && line.indexOf( "Native Stack" ) == -1 )
         {
                        ++linecount;

            firstChar = (line.trim()).charAt( 0 );
            if( firstChar == '\"' ) // new thread
            {
                                   int idx1 = line.indexOf( '\"' );
                                   int idx2 = line.indexOf( '\"', idx1+1 );
                                   String thdNm = line.substring( idx1+1, idx2 );
                                   idx1 = line.indexOf( "sys_thread_t:" );
                                   String line2 = line.substring( idx1 );
                                   idx2 = line2.indexOf( ',' );
                                   String threadId = line2.substring( 13, idx2 );
                                   idx1 = line.indexOf( "state:" )+6; 
                                   idx2 = line.indexOf( ',', idx1 );
                                   String state = line.substring( idx1, idx2 );
                                   idx1 = line.indexOf( "prio=" );
                                   String priority = line.substring( idx1+5 );
                                   logDebug( thdNm + " - " + threadId + " - " + state + " - " + priority );
                                   thd = d.addThd( thdNm, threadId, state, priority );
            }
            else // thread stack entry
            {
               if( line.indexOf("...") == -1 && line.indexOf( ", sp =" ) == -1 )
               {
                  String line2 = "";

                  if( line.charAt(0) == '\t' )
                    line2 = line.substring( 4 );
                  else
                    line2 = line; // to handle Bobcat weirdness, missing tab and 'at'

                  boolean isNative = false;
                  String moduleName = null;
                  String lineno = null;
                  int idx1 = line2.indexOf( "(Native Method)" );
                  if( idx1 > 0 )
                  {
                     isNative = true;

                     line2 = line2.substring( 0, idx1 );
                  }
                  else
                  {
                     idx1 = line2.indexOf( "(" );
                     ++idx1;
                     String moduleInfo = line2.substring( idx1 );
                                         try
                                         {
                                                 line2 = line2.substring( 0, idx1-1 );
                                         }
                                         catch( java.lang.StringIndexOutOfBoundsException e )
                                         {
                                                 System.err.println(linecount + ": line2 = " + line2 + "  idx1 = " + idx1 );
                                                 e.printStackTrace();
                                         }

                     int idx2 = moduleInfo.indexOf( ':' );
                     if( idx2 > 0 )
                     {
                        lineno = moduleInfo.substring( idx2+1, moduleInfo.indexOf( ')', idx2)-1 );
                        moduleName = moduleInfo.substring( 0, idx2 ); 
                     }
                     else
                     {
                        idx2 = moduleInfo.indexOf( '(' );
                        if( idx2 == -1 )
                           idx2 = moduleInfo.indexOf( ')' );

                                                try
                                                {
                                                        moduleName = moduleInfo.substring( 0, idx2 );
                                                }
                                                catch( java.lang.StringIndexOutOfBoundsException e )
                                                {
                                                        System.err.println(linecount + ": line2 = " + line2 + "  idx1 = " + idx1 );
                                                        e.printStackTrace();
                                                }
                     }
                  }
                  String method = line2.substring( line2.lastIndexOf( '.' ) + 1 );
                  String pkg = line2.substring( 0, line2.lastIndexOf( '.' ) );
                  int iLineNo = -1;
                  if( lineno != null )
                  {
                     iLineNo = Integer.parseInt( lineno );
                  }
                  StkEntry se = new StkEntry( method, pkg, moduleName, iLineNo, isNative );
                  logDebug( "  -- " + pkg + " . " + method + " - "  +  " - " + moduleName + " - " + lineno + " - " + isNative );
                  thd.addStackEntry( se );
               }
            }
            line = getLine( d );
         }

         line = getLine( d );

                        //dipak
                        // should also check if line is empty
         while( line != null && line.length() > 0  && line.indexOf("----") == -1 && line.indexOf("Exception") == -1 )
         {
             int iHexStart = line.indexOf("at") + 3;
             int iHexEnd   = line.indexOf(" ", iHexStart);

             String sHex      = line.substring( iHexStart, iHexEnd ); 
             String sFunction = line.substring( line.indexOf("in")+3 );

             if( line.indexOf("allegedly") == -1 && line.indexOf("unavailable") == -1 )
             {
                 StkEntryNative sen = new StkEntryNative( sFunction, sHex );
                 logDebug( "  -- " + sHex + " -- " + sFunction );
                 thd.addStackEntryNative( sen );
             }
             else
             {
                 StkEntryNative sen = new StkEntryNative( null, line.trim() );
                 logDebug( "  -- " + line );
                 thd.addStackEntryNative( sen );
             }

             line = getLine( d );
         }
      }
   }
}
